/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.UnknownHttpStatusCodeException;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.reactive.function.client.WebClientUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultClientResponse
implements ClientResponse {
    private static final byte[] EMPTY = new byte[0];
    private final ClientHttpResponse response;
    private final ClientResponse.Headers headers;
    private final ExchangeStrategies strategies;
    private final String logPrefix;
    private final String requestDescription;
    private final Supplier<HttpRequest> requestSupplier;
    private final BodyExtractor.Context bodyExtractorContext;

    public DefaultClientResponse(ClientHttpResponse response, final ExchangeStrategies strategies, final String logPrefix, String requestDescription, Supplier<HttpRequest> requestSupplier) {
        this.response = response;
        this.strategies = strategies;
        this.headers = new DefaultHeaders();
        this.logPrefix = logPrefix;
        this.requestDescription = requestDescription;
        this.requestSupplier = requestSupplier;
        this.bodyExtractorContext = new BodyExtractor.Context(){

            @Override
            public List<HttpMessageReader<?>> messageReaders() {
                return strategies.messageReaders();
            }

            @Override
            public Optional<ServerHttpResponse> serverResponse() {
                return Optional.empty();
            }

            @Override
            public Map<String, Object> hints() {
                return Hints.from((String)Hints.LOG_PREFIX_HINT, (Object)logPrefix);
            }
        };
    }

    @Override
    public ExchangeStrategies strategies() {
        return this.strategies;
    }

    @Override
    public HttpStatusCode statusCode() {
        return this.response.getStatusCode();
    }

    @Override
    public ClientResponse.Headers headers() {
        return this.headers;
    }

    @Override
    public MultiValueMap<String, ResponseCookie> cookies() {
        return this.response.getCookies();
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ClientHttpResponse> extractor) {
        T result = extractor.extract((ClientHttpResponse)this.response, this.bodyExtractorContext);
        String description = "Body from " + this.requestDescription + " [DefaultClientResponse]";
        if (result instanceof Mono) {
            Mono mono = (Mono)result;
            return (T)mono.checkpoint(description);
        }
        if (result instanceof Flux) {
            Flux flux = (Flux)result;
            return (T)flux.checkpoint(description);
        }
        return result;
    }

    @Override
    public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
        return this.body(BodyExtractors.toMono(elementClass));
    }

    @Override
    public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> elementTypeRef) {
        return this.body(BodyExtractors.toMono(elementTypeRef));
    }

    @Override
    public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
        return elementClass.equals(DataBuffer.class) ? this.body(BodyExtractors.toDataBuffers()) : this.body(BodyExtractors.toFlux(elementClass));
    }

    @Override
    public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> elementTypeRef) {
        return this.body(BodyExtractors.toFlux(elementTypeRef));
    }

    @Override
    public Mono<Void> releaseBody() {
        return this.body(BodyExtractors.toDataBuffers()).map(DataBufferUtils::release).then();
    }

    @Override
    public Mono<ResponseEntity<Void>> toBodilessEntity() {
        return this.releaseBody().then(WebClientUtils.mapToEntity(this, Mono.empty()));
    }

    @Override
    public <T> Mono<ResponseEntity<T>> toEntity(Class<T> bodyType) {
        return WebClientUtils.mapToEntity(this, this.bodyToMono(bodyType));
    }

    @Override
    public <T> Mono<ResponseEntity<T>> toEntity(ParameterizedTypeReference<T> bodyTypeReference) {
        return WebClientUtils.mapToEntity(this, this.bodyToMono(bodyTypeReference));
    }

    @Override
    public <T> Mono<ResponseEntity<List<T>>> toEntityList(Class<T> elementClass) {
        return WebClientUtils.mapToEntityList(this, this.bodyToFlux(elementClass));
    }

    @Override
    public <T> Mono<ResponseEntity<List<T>>> toEntityList(ParameterizedTypeReference<T> elementTypeRef) {
        return WebClientUtils.mapToEntityList(this, this.bodyToFlux(elementTypeRef));
    }

    @Override
    public Mono<WebClientResponseException> createException() {
        return this.bodyToMono(byte[].class).defaultIfEmpty((Object)EMPTY).onErrorReturn(ex -> !(ex instanceof Error), (Object)EMPTY).map(bodyBytes -> {
            WebClientResponseException exception;
            HttpRequest request = this.requestSupplier.get();
            Optional<MediaType> mediaType = this.headers().contentType();
            Charset charset = mediaType.map(MimeType::getCharset).orElse(null);
            HttpStatusCode statusCode = this.statusCode();
            if (statusCode instanceof HttpStatus) {
                HttpStatus httpStatus = (HttpStatus)statusCode;
                exception = WebClientResponseException.create(statusCode, httpStatus.getReasonPhrase(), this.headers().asHttpHeaders(), bodyBytes, charset, request);
            } else {
                exception = new UnknownHttpStatusCodeException(statusCode, this.headers().asHttpHeaders(), (byte[])bodyBytes, charset, request);
            }
            exception.setBodyDecodeFunction(this.initDecodeFunction((byte[])bodyBytes, mediaType.orElse(null)));
            return exception;
        });
    }

    private Function<ResolvableType, ?> initDecodeFunction(byte[] body2, @Nullable MediaType contentType) {
        return targetType -> {
            if (ObjectUtils.isEmpty((Object)body2)) {
                return null;
            }
            Decoder decoder = null;
            for (HttpMessageReader<?> reader : this.strategies().messageReaders()) {
                if (!reader.canRead(targetType, contentType) || !(reader instanceof DecoderHttpMessageReader)) continue;
                DecoderHttpMessageReader decoderReader = (DecoderHttpMessageReader)reader;
                decoder = decoderReader.getDecoder();
                break;
            }
            Assert.state((decoder != null ? 1 : 0) != 0, (String)"No suitable decoder");
            DefaultDataBuffer buffer = DefaultDataBufferFactory.sharedInstance.wrap(body2);
            return decoder.decode((DataBuffer)buffer, targetType, null, Collections.emptyMap());
        };
    }

    @Override
    public <T> Mono<T> createError() {
        return this.createException().flatMap(Mono::error);
    }

    @Override
    public String logPrefix() {
        return this.logPrefix;
    }

    @Override
    public HttpRequest request() {
        return this.requestSupplier.get();
    }

    private class DefaultHeaders
    implements ClientResponse.Headers {
        private final HttpHeaders httpHeaders;

        private DefaultHeaders() {
            this.httpHeaders = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)DefaultClientResponse.this.response.getHeaders());
        }

        @Override
        public OptionalLong contentLength() {
            return this.toOptionalLong(this.httpHeaders.getContentLength());
        }

        @Override
        public Optional<MediaType> contentType() {
            return Optional.ofNullable(this.httpHeaders.getContentType());
        }

        @Override
        public List<String> header(String headerName) {
            List<String> headerValues = this.httpHeaders.get((Object)headerName);
            return headerValues != null ? headerValues : Collections.emptyList();
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return this.httpHeaders;
        }

        private OptionalLong toOptionalLong(long value) {
            return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
        }
    }
}

