/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.accept.RequestedContentTypeResolverBuilder;
import org.springframework.web.reactive.result.condition.ConsumesRequestCondition;
import org.springframework.web.reactive.result.condition.RequestCondition;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.RequestMappingInfoHandlerMapping;
import org.springframework.web.service.annotation.HttpExchange;

public class RequestMappingHandlerMapping
extends RequestMappingInfoHandlerMapping
implements EmbeddedValueResolverAware {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final RequestMethod[] EMPTY_REQUEST_METHOD_ARRAY = new RequestMethod[0];
    private final Map<String, Predicate<Class<?>>> pathPrefixes = new LinkedHashMap();
    private RequestedContentTypeResolver contentTypeResolver = new RequestedContentTypeResolverBuilder().build();
    @Nullable
    private StringValueResolver embeddedValueResolver;
    private RequestMappingInfo.BuilderConfiguration config = new RequestMappingInfo.BuilderConfiguration();

    public void setPathPrefixes(Map<String, Predicate<Class<?>>> prefixes) {
        this.pathPrefixes.clear();
        prefixes.entrySet().stream().filter(entry -> StringUtils.hasText((String)((String)entry.getKey()))).forEach(entry -> this.pathPrefixes.put((String)entry.getKey(), (Predicate)entry.getValue()));
    }

    public Map<String, Predicate<Class<?>>> getPathPrefixes() {
        return Collections.unmodifiableMap(this.pathPrefixes);
    }

    public void setContentTypeResolver(RequestedContentTypeResolver contentTypeResolver) {
        Assert.notNull((Object)contentTypeResolver, (String)"'contentTypeResolver' must not be null");
        this.contentTypeResolver = contentTypeResolver;
    }

    public RequestedContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Override
    public void afterPropertiesSet() {
        this.config = new RequestMappingInfo.BuilderConfiguration();
        this.config.setPatternParser(this.getPathPatternParser());
        this.config.setContentTypeResolver(this.getContentTypeResolver());
        super.afterPropertiesSet();
    }

    @Override
    protected boolean isHandler(Class<?> beanType) {
        return AnnotatedElementUtils.hasAnnotation(beanType, Controller.class);
    }

    @Override
    @Nullable
    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo info = this.createRequestMappingInfo(method);
        if (info != null) {
            RequestMappingInfo typeInfo = this.createRequestMappingInfo(handlerType);
            if (typeInfo != null) {
                info = typeInfo.combine(info);
            }
            if (info.getPatternsCondition().isEmptyPathMapping()) {
                info = info.mutate().paths("", "/").options(this.config).build();
            }
            for (Map.Entry<String, Predicate<Class<?>>> entry : this.pathPrefixes.entrySet()) {
                if (!entry.getValue().test(handlerType)) continue;
                String prefix = entry.getKey();
                if (this.embeddedValueResolver != null) {
                    prefix = this.embeddedValueResolver.resolveStringValue(prefix);
                }
                info = RequestMappingInfo.paths(prefix).options(this.config).build().combine(info);
                break;
            }
        }
        return info;
    }

    @Nullable
    private RequestMappingInfo createRequestMappingInfo(AnnotatedElement element) {
        RequestCondition<?> requestCondition;
        if (element instanceof Class) {
            Class clazz = (Class)element;
            requestCondition = this.getCustomTypeCondition(clazz);
        } else {
            requestCondition = this.getCustomMethodCondition((Method)element);
        }
        RequestCondition<?> customCondition = requestCondition;
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, RequestMapping.class);
        if (requestMapping != null) {
            return this.createRequestMappingInfo(requestMapping, customCondition);
        }
        HttpExchange httpExchange = (HttpExchange)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, HttpExchange.class);
        if (httpExchange != null) {
            return this.createRequestMappingInfo(httpExchange, customCondition);
        }
        return null;
    }

    @Nullable
    protected RequestCondition<?> getCustomTypeCondition(Class<?> handlerType) {
        return null;
    }

    @Nullable
    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        return null;
    }

    protected RequestMappingInfo createRequestMappingInfo(RequestMapping requestMapping, @Nullable RequestCondition<?> customCondition) {
        RequestMappingInfo.Builder builder = RequestMappingInfo.paths(this.resolveEmbeddedValuesInPatterns(requestMapping.path())).methods(requestMapping.method()).params(requestMapping.params()).headers(requestMapping.headers()).consumes(requestMapping.consumes()).produces(requestMapping.produces()).mappingName(requestMapping.name());
        if (customCondition != null) {
            builder.customCondition(customCondition);
        }
        return builder.options(this.config).build();
    }

    protected RequestMappingInfo createRequestMappingInfo(HttpExchange httpExchange, @Nullable RequestCondition<?> customCondition) {
        RequestMappingInfo.Builder builder = RequestMappingInfo.paths(this.resolveEmbeddedValuesInPatterns(RequestMappingHandlerMapping.toStringArray(httpExchange.value()))).methods(RequestMappingHandlerMapping.toMethodArray(httpExchange.method())).consumes(RequestMappingHandlerMapping.toStringArray(httpExchange.contentType())).produces(httpExchange.accept());
        if (customCondition != null) {
            builder.customCondition(customCondition);
        }
        return builder.options(this.config).build();
    }

    protected String[] resolveEmbeddedValuesInPatterns(String[] patterns) {
        if (this.embeddedValueResolver == null) {
            return patterns;
        }
        String[] resolvedPatterns = new String[patterns.length];
        for (int i2 = 0; i2 < patterns.length; ++i2) {
            resolvedPatterns[i2] = this.embeddedValueResolver.resolveStringValue(patterns[i2]);
        }
        return resolvedPatterns;
    }

    private static String[] toStringArray(String value) {
        String[] stringArray;
        if (StringUtils.hasText((String)value)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        } else {
            stringArray = EMPTY_STRING_ARRAY;
        }
        return stringArray;
    }

    private static RequestMethod[] toMethodArray(String method) {
        RequestMethod[] requestMethodArray;
        if (StringUtils.hasText((String)method)) {
            RequestMethod[] requestMethodArray2 = new RequestMethod[1];
            requestMethodArray = requestMethodArray2;
            requestMethodArray2[0] = RequestMethod.valueOf((String)method);
        } else {
            requestMethodArray = EMPTY_REQUEST_METHOD_ARRAY;
        }
        return requestMethodArray;
    }

    @Override
    public void registerMapping(RequestMappingInfo mapping, Object handler, Method method) {
        super.registerMapping(mapping, handler, method);
        this.updateConsumesCondition(mapping, method);
    }

    @Override
    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        super.registerHandlerMethod(handler, method, mapping);
        this.updateConsumesCondition(mapping, method);
    }

    private void updateConsumesCondition(RequestMappingInfo info, Method method) {
        ConsumesRequestCondition condition = info.getConsumesCondition();
        if (!condition.isEmpty()) {
            for (Parameter parameter : method.getParameters()) {
                MergedAnnotation annot = MergedAnnotations.from((AnnotatedElement)parameter).get(RequestBody.class);
                if (!annot.isPresent()) continue;
                condition.setBodyRequired(annot.getBoolean("required"));
                break;
            }
        }
    }

    @Override
    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mappingInfo) {
        HandlerMethod handlerMethod = this.createHandlerMethod(handler, method);
        Class beanType = handlerMethod.getBeanType();
        CrossOrigin typeAnnotation = (CrossOrigin)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)beanType, CrossOrigin.class);
        CrossOrigin methodAnnotation = (CrossOrigin)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, CrossOrigin.class);
        if (typeAnnotation == null && methodAnnotation == null) {
            return null;
        }
        CorsConfiguration config = new CorsConfiguration();
        this.updateCorsConfig(config, typeAnnotation);
        this.updateCorsConfig(config, methodAnnotation);
        if (CollectionUtils.isEmpty((Collection)config.getAllowedMethods())) {
            for (RequestMethod allowedMethod : mappingInfo.getMethodsCondition().getMethods()) {
                config.addAllowedMethod(allowedMethod.name());
            }
        }
        return config.applyPermitDefaultValues();
    }

    private void updateCorsConfig(CorsConfiguration config, @Nullable CrossOrigin annotation) {
        if (annotation == null) {
            return;
        }
        for (String string : annotation.origins()) {
            config.addAllowedOrigin(this.resolveCorsAnnotationValue(string));
        }
        for (String string : annotation.originPatterns()) {
            config.addAllowedOriginPattern(this.resolveCorsAnnotationValue(string));
        }
        for (String string : annotation.methods()) {
            config.addAllowedMethod(string.name());
        }
        for (String string : annotation.allowedHeaders()) {
            config.addAllowedHeader(this.resolveCorsAnnotationValue(string));
        }
        for (String string : annotation.exposedHeaders()) {
            config.addExposedHeader(this.resolveCorsAnnotationValue(string));
        }
        String allowCredentials = this.resolveCorsAnnotationValue(annotation.allowCredentials());
        if ("true".equalsIgnoreCase(allowCredentials)) {
            config.setAllowCredentials(Boolean.valueOf(true));
        } else if ("false".equalsIgnoreCase(allowCredentials)) {
            config.setAllowCredentials(Boolean.valueOf(false));
        } else if (!allowCredentials.isEmpty()) {
            throw new IllegalStateException("@CrossOrigin's allowCredentials value must be \"true\", \"false\", or an empty string (\"\"): current value is [" + allowCredentials + "]");
        }
        String allowPrivateNetwork = this.resolveCorsAnnotationValue(annotation.allowPrivateNetwork());
        if ("true".equalsIgnoreCase(allowPrivateNetwork)) {
            config.setAllowPrivateNetwork(Boolean.valueOf(true));
        } else if ("false".equalsIgnoreCase(allowPrivateNetwork)) {
            config.setAllowPrivateNetwork(Boolean.valueOf(false));
        } else if (!allowPrivateNetwork.isEmpty()) {
            throw new IllegalStateException("@CrossOrigin's allowPrivateNetwork value must be \"true\", \"false\", or an empty string (\"\"): current value is [" + allowPrivateNetwork + "]");
        }
        if (annotation.maxAge() >= 0L) {
            config.setMaxAge(Long.valueOf(annotation.maxAge()));
        }
    }

    private String resolveCorsAnnotationValue(String value) {
        if (this.embeddedValueResolver != null) {
            String resolved = this.embeddedValueResolver.resolveStringValue(value);
            return resolved != null ? resolved : "";
        }
        return value;
    }
}

