/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.web.reactive.resource.VersionStrategy;

public abstract class AbstractPrefixVersionStrategy
implements VersionStrategy {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final String prefix;

    protected AbstractPrefixVersionStrategy(String version) {
        Assert.hasText((String)version, (String)"Version must not be empty");
        this.prefix = version;
    }

    @Override
    public String extractVersion(String requestPath) {
        return requestPath.startsWith(this.prefix) ? this.prefix : null;
    }

    @Override
    public String removeVersion(String requestPath, String version) {
        return requestPath.substring(this.prefix.length());
    }

    @Override
    public String addVersion(String path, String version) {
        if (path.startsWith(".")) {
            return path;
        }
        if (this.prefix.endsWith("/") || path.startsWith("/")) {
            return this.prefix + path;
        }
        return this.prefix + "/" + path;
    }
}

