/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueSyncArgumentResolver;
import org.springframework.web.server.MissingRequestValueException;
import org.springframework.web.server.ServerWebExchange;

public class RequestHeaderMethodArgumentResolver
extends AbstractNamedValueSyncArgumentResolver {
    public RequestHeaderMethodArgumentResolver(@Nullable ConfigurableBeanFactory factory, ReactiveAdapterRegistry registry) {
        super(factory, registry);
    }

    @Override
    public boolean supportsParameter(MethodParameter param) {
        return this.checkAnnotatedParamNoReactiveWrapper(param, RequestHeader.class, this::singleParam);
    }

    private boolean singleParam(RequestHeader annotation, Class<?> type) {
        return !Map.class.isAssignableFrom(type);
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestHeader ann = (RequestHeader)parameter.getParameterAnnotation(RequestHeader.class);
        Assert.state((ann != null ? 1 : 0) != 0, (String)"No RequestHeader annotation");
        return new RequestHeaderNamedValueInfo(ann);
    }

    @Override
    protected Object resolveNamedValue(String name, MethodParameter parameter, ServerWebExchange exchange) {
        List headerValues = exchange.getRequest().getHeaders().get((Object)name);
        List result = null;
        if (headerValues != null) {
            result = headerValues.size() == 1 ? headerValues.get(0) : headerValues;
        }
        return result;
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        throw new MissingRequestValueException(name, parameter.getNestedParameterType(), "header", parameter);
    }

    private static final class RequestHeaderNamedValueInfo
    extends AbstractNamedValueArgumentResolver.NamedValueInfo {
        private RequestHeaderNamedValueInfo(RequestHeader annotation) {
            super(annotation.name(), annotation.required(), annotation.defaultValue());
        }
    }
}

