/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.resource.DefaultResourceResolverChain;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceWebHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;

public class ResourceUrlProvider
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(ResourceUrlProvider.class);
    private final Map<PathPattern, ResourceWebHandler> handlerMap = new LinkedHashMap<PathPattern, ResourceWebHandler>();
    @Nullable
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Map<PathPattern, ResourceWebHandler> getHandlerMap() {
        return Collections.unmodifiableMap(this.handlerMap);
    }

    public void registerHandlers(Map<String, ResourceWebHandler> handlerMap) {
        this.handlerMap.clear();
        handlerMap.forEach((rawPattern, resourceWebHandler) -> {
            rawPattern = ResourceUrlProvider.prependLeadingSlash(rawPattern);
            PathPattern pattern = PathPatternParser.defaultInstance.parse(rawPattern);
            this.handlerMap.put(pattern, (ResourceWebHandler)resourceWebHandler);
        });
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.applicationContext == event.getApplicationContext() && this.handlerMap.isEmpty()) {
            this.detectResourceHandlers(this.applicationContext);
        }
    }

    private void detectResourceHandlers(ApplicationContext context) {
        Map beans = context.getBeansOfType(SimpleUrlHandlerMapping.class);
        ArrayList mappings = new ArrayList(beans.values());
        AnnotationAwareOrderComparator.sort(mappings);
        mappings.forEach(mapping -> mapping.getHandlerMap().forEach((pattern, handler) -> {
            if (handler instanceof ResourceWebHandler) {
                ResourceWebHandler resourceHandler = (ResourceWebHandler)handler;
                this.handlerMap.put((PathPattern)pattern, resourceHandler);
            }
        }));
        if (this.handlerMap.isEmpty()) {
            logger.trace((Object)"No resource handling mappings found");
        }
    }

    public final Mono<String> getForUriString(String uriString, ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        int queryIndex = this.getQueryIndex(uriString);
        String lookupPath = uriString.substring(0, queryIndex);
        String query = uriString.substring(queryIndex);
        PathContainer parsedLookupPath = PathContainer.parsePath((String)lookupPath);
        return this.resolveResourceUrl(exchange, parsedLookupPath).map(resolvedPath -> request.getPath().contextPath().value() + resolvedPath + query);
    }

    private int getQueryIndex(String path) {
        int hashIndex;
        int suffixIndex = path.length();
        int queryIndex = path.indexOf(63);
        if (queryIndex > 0) {
            suffixIndex = queryIndex;
        }
        if ((hashIndex = path.indexOf(35)) > 0) {
            suffixIndex = Math.min(suffixIndex, hashIndex);
        }
        return suffixIndex;
    }

    private Mono<String> resolveResourceUrl(ServerWebExchange exchange, PathContainer lookupPath) {
        return this.handlerMap.entrySet().stream().filter(entry -> ((PathPattern)entry.getKey()).matches(lookupPath)).min((entry1, entry2) -> PathPattern.SPECIFICITY_COMPARATOR.compare((PathPattern)entry1.getKey(), (PathPattern)entry2.getKey())).map(entry -> {
            PathContainer path = ((PathPattern)entry.getKey()).extractPathWithinPattern(lookupPath);
            int endIndex = lookupPath.elements().size() - path.elements().size();
            PathContainer mapping = lookupPath.subPath(0, endIndex);
            ResourceWebHandler handler = (ResourceWebHandler)entry.getValue();
            List<ResourceResolver> resolvers = handler.getResourceResolvers();
            DefaultResourceResolverChain chain = new DefaultResourceResolverChain(resolvers);
            return chain.resolveUrlPath(path.value(), handler.getLocations()).map(resolvedPath -> mapping.value() + resolvedPath);
        }).orElseGet(() -> {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(exchange.getLogPrefix() + "No match for \"" + lookupPath + "\""));
            }
            return Mono.empty();
        });
    }

    private static String prependLeadingSlash(String pattern) {
        if (StringUtils.hasLength((String)pattern) && !pattern.startsWith("/")) {
            return "/" + pattern;
        }
        return pattern;
    }
}

