/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Encoder;
import org.springframework.core.codec.Hints;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class HttpMessageWriterView
implements View {
    private final HttpMessageWriter<?> writer;
    private final Set<String> modelKeys = new HashSet<String>(4);
    private final boolean canWriteMap;

    public HttpMessageWriterView(Encoder<?> encoder) {
        this((HttpMessageWriter<?>)new EncoderHttpMessageWriter(encoder));
    }

    public HttpMessageWriterView(HttpMessageWriter<?> writer) {
        Assert.notNull(writer, (String)"HttpMessageWriter is required");
        this.writer = writer;
        this.canWriteMap = writer.canWrite(ResolvableType.forClass(Map.class), null);
    }

    public HttpMessageWriter<?> getMessageWriter() {
        return this.writer;
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return this.writer.getWritableMediaTypes();
    }

    public void setModelKeys(@Nullable Set<String> modelKeys) {
        this.modelKeys.clear();
        if (modelKeys != null) {
            this.modelKeys.addAll(modelKeys);
        }
    }

    public final Set<String> getModelKeys() {
        return this.modelKeys;
    }

    @Override
    public Mono<Void> render(@Nullable Map<String, ?> model, @Nullable MediaType contentType, ServerWebExchange exchange) {
        Object value = this.getObjectToRender(model);
        return value != null ? this.write(value, contentType, exchange) : exchange.getResponse().setComplete();
    }

    @Nullable
    private Object getObjectToRender(@Nullable Map<String, ?> model) {
        if (model == null) {
            return null;
        }
        Map<String, Object> result = model.entrySet().stream().filter(this::isMatch).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return result.values().iterator().next();
        }
        if (this.canWriteMap) {
            return result;
        }
        throw new IllegalStateException("Multiple matches found: " + result + " but Map rendering is not supported by " + this.getMessageWriter().getClass().getName());
    }

    private boolean isMatch(Map.Entry<String, ?> entry) {
        if (entry.getValue() == null) {
            return false;
        }
        if (!this.getModelKeys().isEmpty() && !this.getModelKeys().contains(entry.getKey())) {
            return false;
        }
        ResolvableType type = ResolvableType.forInstance(entry.getValue());
        return this.getMessageWriter().canWrite(type, null);
    }

    private <T> Mono<Void> write(T value, @Nullable MediaType contentType, ServerWebExchange exchange) {
        Mono input = Mono.justOrEmpty(value);
        ResolvableType elementType = ResolvableType.forClass(value.getClass());
        return this.writer.write((Publisher)input, elementType, contentType, (ReactiveHttpOutputMessage)exchange.getResponse(), Hints.from((String)Hints.LOG_PREFIX_HINT, (Object)exchange.getLogPrefix()));
    }
}

