/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

public class RequestHeaderMapMethodArgumentResolver
extends HandlerMethodArgumentResolverSupport
implements SyncHandlerMethodArgumentResolver {
    public RequestHeaderMapMethodArgumentResolver(ReactiveAdapterRegistry adapterRegistry) {
        super(adapterRegistry);
    }

    @Override
    public boolean supportsParameter(MethodParameter param) {
        return this.checkAnnotatedParamNoReactiveWrapper(param, RequestHeader.class, this::allParams);
    }

    private boolean allParams(RequestHeader annotation, Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    @Override
    public Object resolveArgumentValue(MethodParameter methodParameter, BindingContext context, ServerWebExchange exchange) {
        boolean isMultiValueMap = MultiValueMap.class.isAssignableFrom(methodParameter.getParameterType());
        HttpHeaders headers = exchange.getRequest().getHeaders();
        return isMultiValueMap ? headers : headers.toSingleValueMap();
    }
}

