/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.Locale;
import java.util.function.Function;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.reactive.result.view.AbstractUrlBasedView;
import org.springframework.web.reactive.result.view.RedirectView;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.reactive.result.view.ViewResolverSupport;
import reactor.core.publisher.Mono;

public class UrlBasedViewResolver
extends ViewResolverSupport
implements ViewResolver,
ApplicationContextAware,
InitializingBean {
    public static final String REDIRECT_URL_PREFIX = "redirect:";
    @Nullable
    private Class<?> viewClass;
    private String prefix = "";
    private String suffix = "";
    @Nullable
    private String[] viewNames;
    private Function<String, RedirectView> redirectViewProvider = RedirectView::new;
    @Nullable
    private String requestContextAttribute;
    @Nullable
    private ApplicationContext applicationContext;

    public void setViewClass(@Nullable Class<?> viewClass) {
        if (viewClass != null && !this.requiredViewClass().isAssignableFrom(viewClass)) {
            String name = viewClass.getName();
            throw new IllegalArgumentException("Given view class [" + name + "] is not of type [" + this.requiredViewClass().getName() + "]");
        }
        this.viewClass = viewClass;
    }

    @Nullable
    protected Class<?> getViewClass() {
        return this.viewClass;
    }

    public void setPrefix(@Nullable String prefix) {
        this.prefix = prefix != null ? prefix : "";
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void setSuffix(@Nullable String suffix) {
        this.suffix = suffix != null ? suffix : "";
    }

    protected String getSuffix() {
        return this.suffix;
    }

    public void setViewNames(String ... viewNames) {
        this.viewNames = viewNames;
    }

    @Nullable
    protected String[] getViewNames() {
        return this.viewNames;
    }

    public void setRedirectViewProvider(Function<String, RedirectView> redirectViewProvider) {
        this.redirectViewProvider = redirectViewProvider;
    }

    public void setRequestContextAttribute(@Nullable String requestContextAttribute) {
        this.requestContextAttribute = requestContextAttribute;
    }

    @Nullable
    protected String getRequestContextAttribute() {
        return this.requestContextAttribute;
    }

    public void setApplicationContext(@Nullable ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Nullable
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getViewClass() == null) {
            throw new IllegalArgumentException("Property 'viewClass' is required");
        }
    }

    @Override
    public Mono<View> resolveViewName(String viewName, Locale locale) {
        AbstractUrlBasedView urlBasedView;
        if (!this.canHandle(viewName, locale)) {
            return Mono.empty();
        }
        if (viewName.startsWith(REDIRECT_URL_PREFIX)) {
            String redirectUrl = viewName.substring(REDIRECT_URL_PREFIX.length());
            urlBasedView = this.redirectViewProvider.apply(redirectUrl);
        } else {
            urlBasedView = this.createView(viewName);
        }
        View view = this.applyLifecycleMethods(viewName, urlBasedView);
        try {
            return urlBasedView.checkResourceExists(locale) ? Mono.just((Object)view) : Mono.empty();
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
    }

    protected boolean canHandle(String viewName, Locale locale) {
        String[] viewNames = this.getViewNames();
        return viewNames == null || PatternMatchUtils.simpleMatch((String[])viewNames, (String)viewName);
    }

    protected Class<?> requiredViewClass() {
        return AbstractUrlBasedView.class;
    }

    protected AbstractUrlBasedView instantiateView() {
        Class<?> viewClass = this.getViewClass();
        Assert.state((viewClass != null ? 1 : 0) != 0, (String)"No view class");
        return (AbstractUrlBasedView)BeanUtils.instantiateClass(viewClass);
    }

    protected AbstractUrlBasedView createView(String viewName) {
        AbstractUrlBasedView view = this.instantiateView();
        view.setSupportedMediaTypes(this.getSupportedMediaTypes());
        view.setDefaultCharset(this.getDefaultCharset());
        view.setUrl(this.getPrefix() + viewName + this.getSuffix());
        String requestContextAttribute = this.getRequestContextAttribute();
        if (requestContextAttribute != null) {
            view.setRequestContextAttribute(requestContextAttribute);
        }
        return view;
    }

    protected View applyLifecycleMethods(String viewName, AbstractUrlBasedView view) {
        Object initialized;
        ApplicationContext context = this.getApplicationContext();
        if (context != null && (initialized = context.getAutowireCapableBeanFactory().initializeBean((Object)view, viewName)) instanceof View) {
            View initializedView = (View)initialized;
            return initializedView;
        }
        return view;
    }
}

