/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.cors.reactive.PreFlightRequestHandler;
import org.springframework.web.reactive.DispatchExceptionHandler;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DispatcherHandler
implements WebHandler,
PreFlightRequestHandler,
ApplicationContextAware {
    @Nullable
    private List<HandlerMapping> handlerMappings;
    @Nullable
    private List<HandlerAdapter> handlerAdapters;
    @Nullable
    private List<HandlerResultHandler> resultHandlers;

    public DispatcherHandler() {
    }

    public DispatcherHandler(ApplicationContext applicationContext) {
        this.initStrategies(applicationContext);
    }

    @Nullable
    public final List<HandlerMapping> getHandlerMappings() {
        return this.handlerMappings;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.initStrategies(applicationContext);
    }

    protected void initStrategies(ApplicationContext context) {
        Map mappingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerMapping.class, (boolean)true, (boolean)false);
        ArrayList mappings = new ArrayList(mappingBeans.values());
        AnnotationAwareOrderComparator.sort(mappings);
        this.handlerMappings = Collections.unmodifiableList(mappings);
        Map adapterBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerAdapter.class, (boolean)true, (boolean)false);
        this.handlerAdapters = new ArrayList(adapterBeans.values());
        AnnotationAwareOrderComparator.sort(this.handlerAdapters);
        Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerResultHandler.class, (boolean)true, (boolean)false);
        this.resultHandlers = new ArrayList(beans.values());
        AnnotationAwareOrderComparator.sort(this.resultHandlers);
    }

    public Mono<Void> handle(ServerWebExchange exchange) {
        if (this.handlerMappings == null) {
            return this.createNotFoundError();
        }
        if (CorsUtils.isPreFlightRequest((ServerHttpRequest)exchange.getRequest())) {
            return this.handlePreFlight(exchange);
        }
        return Flux.fromIterable(this.handlerMappings).concatMap(mapping -> mapping.getHandler(exchange)).next().switchIfEmpty(this.createNotFoundError()).onErrorResume(ex -> this.handleDispatchError(exchange, (Throwable)ex)).flatMap(handler -> this.handleRequestWith(exchange, handler));
    }

    private <R> Mono<R> createNotFoundError() {
        return Mono.defer(() -> {
            ResponseStatusException ex = new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            return Mono.error((Throwable)ex);
        });
    }

    private Mono<Void> handleDispatchError(ServerWebExchange exchange, Throwable ex) {
        Mono resultMono = Mono.error((Throwable)ex);
        if (this.handlerAdapters != null) {
            for (HandlerAdapter adapter : this.handlerAdapters) {
                if (!(adapter instanceof DispatchExceptionHandler)) continue;
                DispatchExceptionHandler exceptionHandler = (DispatchExceptionHandler)((Object)adapter);
                resultMono = resultMono.onErrorResume(ex2 -> exceptionHandler.handleError(exchange, (Throwable)ex2));
            }
        }
        return resultMono.flatMap(result -> this.handleResult(exchange, (HandlerResult)result));
    }

    private Mono<Void> handleRequestWith(ServerWebExchange exchange, Object handler) {
        if (ObjectUtils.nullSafeEquals((Object)exchange.getResponse().getStatusCode(), (Object)HttpStatus.FORBIDDEN)) {
            return Mono.empty();
        }
        if (this.handlerAdapters != null) {
            for (HandlerAdapter adapter : this.handlerAdapters) {
                if (!adapter.supports(handler)) continue;
                return adapter.handle(exchange, handler).flatMap(result -> this.handleResult(exchange, (HandlerResult)result));
            }
        }
        return Mono.error((Throwable)new IllegalStateException("No HandlerAdapter: " + handler));
    }

    private Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        Mono resultMono = this.doHandleResult(exchange, result, "Handler " + result.getHandler());
        if (result.getExceptionHandler() != null) {
            resultMono = resultMono.onErrorResume(ex -> result.getExceptionHandler().handleError(exchange, (Throwable)ex).flatMap(result2 -> this.doHandleResult(exchange, (HandlerResult)result2, "Exception handler " + result2.getHandler() + ", error=\"" + ex.getMessage() + "\"")));
        }
        return resultMono;
    }

    private Mono<Void> doHandleResult(ServerWebExchange exchange, HandlerResult handlerResult, String description) {
        if (this.resultHandlers != null) {
            for (HandlerResultHandler resultHandler : this.resultHandlers) {
                if (!resultHandler.supports(handlerResult)) continue;
                description = (String)description + " [DispatcherHandler]";
                return resultHandler.handleResult(exchange, handlerResult).checkpoint((String)description);
            }
        }
        return Mono.error((Throwable)new IllegalStateException("No HandlerResultHandler for " + handlerResult.getReturnValue()));
    }

    public Mono<Void> handlePreFlight(ServerWebExchange exchange) {
        return Flux.fromIterable(this.handlerMappings != null ? this.handlerMappings : Collections.emptyList()).concatMap(mapping -> mapping.getHandler(exchange)).switchIfEmpty((Publisher)Mono.fromRunnable(() -> exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.FORBIDDEN))).next().then();
    }
}

