/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.support.BindingAwareConcurrentModel;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class BindingContext {
    @Nullable
    private final WebBindingInitializer initializer;
    private final Model model = new BindingAwareConcurrentModel();

    public BindingContext() {
        this(null);
    }

    public BindingContext(@Nullable WebBindingInitializer initializer) {
        this.initializer = initializer;
    }

    public Model getModel() {
        return this.model;
    }

    public WebExchangeDataBinder createDataBinder(ServerWebExchange exchange, @Nullable Object target, String name) {
        ExtendedWebExchangeDataBinder dataBinder = new ExtendedWebExchangeDataBinder(target, name);
        if (this.initializer != null) {
            this.initializer.initBinder((WebDataBinder)dataBinder);
        }
        return this.initDataBinder(dataBinder, exchange);
    }

    protected WebExchangeDataBinder initDataBinder(WebExchangeDataBinder binder, ServerWebExchange exchange) {
        return binder;
    }

    public WebExchangeDataBinder createDataBinder(ServerWebExchange exchange, String name) {
        return this.createDataBinder(exchange, null, name);
    }

    private static class ExtendedWebExchangeDataBinder
    extends WebExchangeDataBinder {
        public ExtendedWebExchangeDataBinder(@Nullable Object target, String objectName) {
            super(target, objectName);
        }

        public Mono<Map<String, Object>> getValuesToBind(ServerWebExchange exchange) {
            Map vars = (Map)exchange.getAttributeOrDefault(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, Collections.emptyMap());
            MultiValueMap queryParams = exchange.getRequest().getQueryParams();
            Mono formData = exchange.getFormData();
            Mono multipartData = exchange.getMultipartData();
            return Mono.zip((Mono)Mono.just((Object)vars), (Mono)Mono.just((Object)queryParams), (Mono)formData, (Mono)multipartData).map(tuple -> {
                TreeMap result = new TreeMap();
                ((Map)tuple.getT1()).forEach(result::put);
                ((MultiValueMap)tuple.getT2()).forEach((key, values) -> ExtendedWebExchangeDataBinder.addBindValue((Map)result, (String)key, (List)values));
                ((MultiValueMap)tuple.getT3()).forEach((key, values) -> ExtendedWebExchangeDataBinder.addBindValue((Map)result, (String)key, (List)values));
                ((MultiValueMap)tuple.getT4()).forEach((key, values) -> ExtendedWebExchangeDataBinder.addBindValue((Map)result, (String)key, (List)values));
                return result;
            });
        }
    }
}

