/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import org.reactivestreams.Publisher;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueSyncArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;

public class RequestAttributeMethodArgumentResolver
extends AbstractNamedValueSyncArgumentResolver {
    public RequestAttributeMethodArgumentResolver(@Nullable ConfigurableBeanFactory factory, ReactiveAdapterRegistry registry) {
        super(factory, registry);
    }

    @Override
    public boolean supportsParameter(MethodParameter param) {
        return param.hasParameterAnnotation(RequestAttribute.class);
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestAttribute ann = (RequestAttribute)parameter.getParameterAnnotation(RequestAttribute.class);
        Assert.state((ann != null ? 1 : 0) != 0, (String)"No RequestAttribute annotation");
        return new AbstractNamedValueArgumentResolver.NamedValueInfo(ann.name(), ann.required(), "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
    }

    @Override
    protected Object resolveNamedValue(String name, MethodParameter parameter, ServerWebExchange exchange) {
        Object value = exchange.getAttribute(name);
        ReactiveAdapter toAdapter = this.getAdapterRegistry().getAdapter(parameter.getParameterType());
        if (toAdapter != null) {
            if (value == null) {
                Assert.isTrue((boolean)toAdapter.supportsEmpty(), () -> "No request attribute '" + name + "' and target type " + parameter.getGenericParameterType() + " doesn't support empty values.");
                return toAdapter.fromPublisher((Publisher)Mono.empty());
            }
            if (parameter.getParameterType().isAssignableFrom(value.getClass())) {
                return value;
            }
            ReactiveAdapter fromAdapter = this.getAdapterRegistry().getAdapter(value.getClass());
            Assert.isTrue((fromAdapter != null ? 1 : 0) != 0, () -> this.getClass().getSimpleName() + " doesn't support reactive type wrapper: " + parameter.getGenericParameterType());
            return toAdapter.fromPublisher(fromAdapter.toPublisher(value));
        }
        return value;
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        String type = parameter.getNestedParameterType().getSimpleName();
        String reason = "Missing request attribute '" + name + "' of type " + type;
        throw new ServerWebInputException(reason, parameter);
    }
}

