/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import org.jspecify.annotations.Nullable;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.util.Assert;
import org.springframework.web.accept.ApiVersionResolver;
import org.springframework.web.util.ServletRequestPathUtils;

public class PathApiVersionResolver
implements ApiVersionResolver {
    private final int pathSegmentIndex;

    public PathApiVersionResolver(int pathSegmentIndex) {
        Assert.isTrue((pathSegmentIndex >= 0 ? 1 : 0) != 0, (String)"'pathSegmentIndex' must be >= 0");
        this.pathSegmentIndex = pathSegmentIndex;
    }

    @Override
    public @Nullable String resolveVersion(HttpServletRequest request) {
        if (ServletRequestPathUtils.hasParsedRequestPath((ServletRequest)request)) {
            RequestPath path = ServletRequestPathUtils.getParsedRequestPath((ServletRequest)request);
            int i = 0;
            for (PathContainer.Element e : path.pathWithinApplication().elements()) {
                if (!(e instanceof PathContainer.PathSegment) || i++ != this.pathSegmentIndex) continue;
                return e.value();
            }
        }
        return null;
    }
}

