/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpLogging;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.DefaultSslInfo;
import org.springframework.http.server.reactive.ReactorUriHelper;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.http.support.Netty4HeadersAdapter;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.netty.ChannelOperationsId;
import reactor.netty.Connection;
import reactor.netty.http.server.HttpServerRequest;

class ReactorServerHttpRequest
extends AbstractServerHttpRequest {
    private static final Log logger = HttpLogging.forLogName(ReactorServerHttpRequest.class);
    private static final AtomicLong logPrefixIndex = new AtomicLong();
    private final HttpServerRequest request;
    private final NettyDataBufferFactory bufferFactory;

    public ReactorServerHttpRequest(HttpServerRequest request, NettyDataBufferFactory bufferFactory) throws URISyntaxException {
        super(HttpMethod.valueOf(request.method().name()), ReactorUriHelper.createUri(request), request.forwardedPrefix(), new HttpHeaders(new Netty4HeadersAdapter(request.requestHeaders())));
        Assert.notNull((Object)bufferFactory, (String)"DataBufferFactory must not be null");
        this.request = request;
        this.bufferFactory = bufferFactory;
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        for (CharSequence name : this.request.allCookies().keySet()) {
            for (Cookie cookie : (List)this.request.allCookies().get(name)) {
                HttpCookie httpCookie = new HttpCookie(name.toString(), cookie.value());
                cookies.add((Object)name.toString(), (Object)httpCookie);
            }
        }
        return cookies;
    }

    @Override
    public @Nullable InetSocketAddress getLocalAddress() {
        return this.request.hostAddress();
    }

    @Override
    public @Nullable InetSocketAddress getRemoteAddress() {
        return this.request.remoteAddress();
    }

    @Override
    protected @Nullable SslInfo initSslInfo() {
        Channel channel = ((Connection)this.request).channel();
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        if (sslHandler == null && channel.parent() != null) {
            sslHandler = (SslHandler)channel.parent().pipeline().get(SslHandler.class);
        }
        if (sslHandler != null) {
            SSLSession session = sslHandler.engine().getSession();
            return new DefaultSslInfo(session);
        }
        return null;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.request.receive().retain().map(arg_0 -> ((NettyDataBufferFactory)this.bufferFactory).wrap(arg_0));
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.request;
    }

    @Override
    protected @Nullable String initId() {
        HttpServerRequest httpServerRequest = this.request;
        if (httpServerRequest instanceof Connection) {
            Connection connection = (Connection)httpServerRequest;
            return connection.channel().id().asShortText() + "-" + logPrefixIndex.incrementAndGet();
        }
        return null;
    }

    @Override
    protected String initLogPrefix() {
        String id = null;
        HttpServerRequest httpServerRequest = this.request;
        if (httpServerRequest instanceof ChannelOperationsId) {
            ChannelOperationsId operationsId = (ChannelOperationsId)httpServerRequest;
            String string = id = logger.isDebugEnabled() ? operationsId.asLongText() : operationsId.asShortText();
        }
        if (id != null) {
            return id;
        }
        httpServerRequest = this.request;
        if (httpServerRequest instanceof Connection) {
            Connection connection = (Connection)httpServerRequest;
            return connection.channel().id().asShortText() + "-" + logPrefixIndex.incrementAndGet();
        }
        return this.getId();
    }
}

