/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.AbstractResource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

class MultipartFileResource
extends AbstractResource {
    private final MultipartFile multipartFile;

    public MultipartFileResource(MultipartFile multipartFile) {
        Assert.notNull((Object)multipartFile, (String)"MultipartFile must not be null");
        this.multipartFile = multipartFile;
    }

    public boolean exists() {
        return true;
    }

    public boolean isOpen() {
        return true;
    }

    public long contentLength() {
        return this.multipartFile.getSize();
    }

    public String getFilename() {
        return this.multipartFile.getOriginalFilename();
    }

    public InputStream getInputStream() throws IOException, IllegalStateException {
        return this.multipartFile.getInputStream();
    }

    public String getDescription() {
        return "MultipartFile resource [" + this.multipartFile.getName() + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof MultipartFileResource)) return false;
        MultipartFileResource other = (MultipartFileResource)((Object)obj);
        if (!this.multipartFile.equals(other.multipartFile)) return false;
        return true;
    }

    public int hashCode() {
        return this.multipartFile.hashCode();
    }
}

