/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.AbstractRefreshableWebApplicationContext;

public class AnnotationConfigWebApplicationContext
extends AbstractRefreshableWebApplicationContext
implements AnnotationConfigRegistry {
    @Nullable
    private BeanNameGenerator beanNameGenerator;
    @Nullable
    private ScopeMetadataResolver scopeMetadataResolver;
    private final Set<Class<?>> annotatedClasses = new LinkedHashSet();
    private final Set<String> basePackages = new LinkedHashSet<String>();

    public void setBeanNameGenerator(@Nullable BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator;
    }

    @Nullable
    protected BeanNameGenerator getBeanNameGenerator() {
        return this.beanNameGenerator;
    }

    public void setScopeMetadataResolver(@Nullable ScopeMetadataResolver scopeMetadataResolver) {
        this.scopeMetadataResolver = scopeMetadataResolver;
    }

    @Nullable
    protected ScopeMetadataResolver getScopeMetadataResolver() {
        return this.scopeMetadataResolver;
    }

    public void register(Class<?> ... annotatedClasses) {
        Assert.notEmpty((Object[])annotatedClasses, (String)"At least one annotated class must be specified");
        this.annotatedClasses.addAll(Arrays.asList(annotatedClasses));
    }

    public void scan(String ... basePackages) {
        Assert.notEmpty((Object[])basePackages, (String)"At least one base package must be specified");
        this.basePackages.addAll(Arrays.asList(basePackages));
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) {
        String[] configLocations;
        ScopeMetadataResolver scopeMetadataResolver;
        AnnotatedBeanDefinitionReader reader = this.getAnnotatedBeanDefinitionReader(beanFactory);
        ClassPathBeanDefinitionScanner scanner = this.getClassPathBeanDefinitionScanner(beanFactory);
        BeanNameGenerator beanNameGenerator = this.getBeanNameGenerator();
        if (beanNameGenerator != null) {
            reader.setBeanNameGenerator(beanNameGenerator);
            scanner.setBeanNameGenerator(beanNameGenerator);
            beanFactory.registerSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator", (Object)beanNameGenerator);
        }
        if ((scopeMetadataResolver = this.getScopeMetadataResolver()) != null) {
            reader.setScopeMetadataResolver(scopeMetadataResolver);
            scanner.setScopeMetadataResolver(scopeMetadataResolver);
        }
        if (!this.annotatedClasses.isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Registering annotated classes: [" + StringUtils.collectionToCommaDelimitedString(this.annotatedClasses) + "]"));
            }
            reader.register(this.annotatedClasses.toArray(new Class[this.annotatedClasses.size()]));
        }
        if (!this.basePackages.isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Scanning base packages: [" + StringUtils.collectionToCommaDelimitedString(this.basePackages) + "]"));
            }
            scanner.scan(StringUtils.toStringArray(this.basePackages));
        }
        if ((configLocations = this.getConfigLocations()) != null) {
            for (String configLocation : configLocations) {
                try {
                    Class clazz = ClassUtils.forName((String)configLocation, (ClassLoader)this.getClassLoader());
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Successfully resolved class for [" + configLocation + "]"));
                    }
                    reader.register(new Class[]{clazz});
                }
                catch (ClassNotFoundException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Could not load class for config location [" + configLocation + "] - trying package scan. " + ex));
                    }
                    int count = scanner.scan(new String[]{configLocation});
                    if (!this.logger.isInfoEnabled()) continue;
                    if (count == 0) {
                        this.logger.info((Object)("No annotated classes found for specified class/package [" + configLocation + "]"));
                        continue;
                    }
                    this.logger.info((Object)("Found " + count + " annotated classes in package [" + configLocation + "]"));
                }
            }
        }
    }

    protected AnnotatedBeanDefinitionReader getAnnotatedBeanDefinitionReader(DefaultListableBeanFactory beanFactory) {
        return new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)beanFactory, (Environment)this.getEnvironment());
    }

    protected ClassPathBeanDefinitionScanner getClassPathBeanDefinitionScanner(DefaultListableBeanFactory beanFactory) {
        return new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)beanFactory, true, (Environment)this.getEnvironment());
    }
}

