/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.session;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.util.Assert;
import org.springframework.util.IdGenerator;
import org.springframework.util.JdkIdGenerator;
import org.springframework.web.server.WebSession;
import org.springframework.web.server.session.WebSessionStore;
import reactor.core.publisher.Mono;

public class InMemoryWebSessionStore
implements WebSessionStore {
    private static final IdGenerator idGenerator = new JdkIdGenerator();
    private Clock clock = Clock.system(ZoneId.of("GMT"));
    private final Map<String, WebSession> sessions = new ConcurrentHashMap<String, WebSession>();

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"'clock' is required.");
        this.clock = clock;
    }

    public Clock getClock() {
        return this.clock;
    }

    @Override
    public Mono<WebSession> createWebSession() {
        return Mono.fromSupplier(() -> new InMemoryWebSession());
    }

    @Override
    public Mono<WebSession> retrieveSession(String id) {
        return this.sessions.containsKey(id) ? Mono.just((Object)this.sessions.get(id)) : Mono.empty();
    }

    @Override
    public Mono<Void> removeSession(String id) {
        this.sessions.remove(id);
        return Mono.empty();
    }

    @Override
    public Mono<WebSession> updateLastAccessTime(WebSession webSession) {
        return Mono.fromSupplier(() -> {
            InMemoryWebSession session = (InMemoryWebSession)webSession;
            Instant lastAccessTime = Instant.now(this.getClock());
            return new InMemoryWebSession(session, lastAccessTime);
        });
    }

    private Mono<Void> changeSessionId(String oldId, WebSession session) {
        this.sessions.remove(oldId);
        this.sessions.put(session.getId(), session);
        return Mono.empty();
    }

    private Mono<Void> storeSession(WebSession session) {
        this.sessions.put(session.getId(), session);
        return Mono.empty();
    }

    private class InMemoryWebSession
    implements WebSession {
        private final AtomicReference<String> id;
        private final Map<String, Object> attributes;
        private final Instant creationTime;
        private final Instant lastAccessTime;
        private volatile Duration maxIdleTime;
        private volatile boolean started;

        InMemoryWebSession() {
            this.id = new AtomicReference<String>(String.valueOf(idGenerator.generateId()));
            this.attributes = new ConcurrentHashMap<String, Object>();
            this.lastAccessTime = this.creationTime = Instant.now(InMemoryWebSessionStore.this.getClock());
            this.maxIdleTime = Duration.ofMinutes(30L);
        }

        InMemoryWebSession(InMemoryWebSession existingSession, Instant lastAccessTime) {
            this.id = existingSession.id;
            this.attributes = existingSession.attributes;
            this.creationTime = existingSession.creationTime;
            this.lastAccessTime = lastAccessTime;
            this.maxIdleTime = existingSession.maxIdleTime;
            this.started = existingSession.isStarted();
        }

        @Override
        public String getId() {
            return this.id.get();
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @Override
        public Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public Instant getLastAccessTime() {
            return this.lastAccessTime;
        }

        @Override
        public void setMaxIdleTime(Duration maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
        }

        @Override
        public Duration getMaxIdleTime() {
            return this.maxIdleTime;
        }

        @Override
        public void start() {
            this.started = true;
        }

        @Override
        public boolean isStarted() {
            return this.started || !this.getAttributes().isEmpty();
        }

        @Override
        public Mono<Void> changeSessionId() {
            String oldId = this.id.get();
            String newId = String.valueOf(idGenerator.generateId());
            this.id.set(newId);
            return InMemoryWebSessionStore.this.changeSessionId(oldId, this).doOnError(ex -> this.id.set(oldId));
        }

        @Override
        public Mono<Void> save() {
            return InMemoryWebSessionStore.this.storeSession(this);
        }

        @Override
        public boolean isExpired() {
            return this.isStarted() && !this.maxIdleTime.isNegative() && Instant.now(InMemoryWebSessionStore.this.getClock()).minus(this.maxIdleTime).isAfter(this.lastAccessTime);
        }
    }
}

