/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request.async;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.ServletRequest;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.AbstractDelegatingCallable;
import org.springframework.web.context.request.async.AsyncExecutionChainRunnable;
import org.springframework.web.context.request.async.AsyncWebRequest;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.StaleAsyncRequestCheckingCallable;
import org.springframework.web.context.request.async.StaleAsyncWebRequestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsyncExecutionChain {
    public static final String CALLABLE_CHAIN_ATTRIBUTE = AsyncExecutionChain.class.getName() + ".CALLABLE_CHAIN";
    private final List<AbstractDelegatingCallable> delegatingCallables = new ArrayList<AbstractDelegatingCallable>();
    private Callable<Object> callable;
    private AsyncWebRequest asyncWebRequest;
    private AsyncTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor("AsyncExecutionChain");

    private AsyncExecutionChain() {
    }

    public static AsyncExecutionChain getForCurrentRequest(ServletRequest request) {
        AsyncExecutionChain chain = (AsyncExecutionChain)request.getAttribute(CALLABLE_CHAIN_ATTRIBUTE);
        if (chain == null) {
            chain = new AsyncExecutionChain();
            request.setAttribute(CALLABLE_CHAIN_ATTRIBUTE, (Object)chain);
        }
        return chain;
    }

    public static AsyncExecutionChain getForCurrentRequest(WebRequest request) {
        int scope = 0;
        AsyncExecutionChain chain = (AsyncExecutionChain)request.getAttribute(CALLABLE_CHAIN_ATTRIBUTE, scope);
        if (chain == null) {
            chain = new AsyncExecutionChain();
            request.setAttribute(CALLABLE_CHAIN_ATTRIBUTE, chain, scope);
        }
        return chain;
    }

    public void setAsyncWebRequest(AsyncWebRequest asyncRequest) {
        this.asyncWebRequest = asyncRequest;
    }

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public boolean isAsyncStarted() {
        return this.asyncWebRequest != null && this.asyncWebRequest.isAsyncStarted();
    }

    public void addDelegatingCallable(AbstractDelegatingCallable callable) {
        Assert.notNull((Object)callable, (String)"Callable required");
        this.delegatingCallables.add(callable);
    }

    public AsyncExecutionChain setCallable(Callable<Object> callable) {
        Assert.notNull(callable, (String)"Callable required");
        this.callable = callable;
        return this;
    }

    public void startCallableChainProcessing() {
        this.startAsync();
        this.taskExecutor.execute((Runnable)new AsyncExecutionChainRunnable(this.asyncWebRequest, this.buildChain()));
    }

    private void startAsync() {
        Assert.state((this.asyncWebRequest != null ? 1 : 0) != 0, (String)"An AsyncWebRequest is required to start async processing");
        this.asyncWebRequest.startAsync();
    }

    private Callable<Object> buildChain() {
        Assert.state((this.callable != null ? 1 : 0) != 0, (String)"The last callable is required to build the async chain");
        this.delegatingCallables.add(new StaleAsyncRequestCheckingCallable(this.asyncWebRequest));
        AbstractDelegatingCallable result = this.callable;
        for (int i = this.delegatingCallables.size() - 1; i >= 0; --i) {
            AbstractDelegatingCallable callable = this.delegatingCallables.get(i);
            callable.setNextCallable(result);
            result = callable;
        }
        return result;
    }

    public void startDeferredResultProcessing(final DeferredResult deferredResult) {
        Assert.notNull((Object)deferredResult, (String)"DeferredResult is required");
        this.startAsync();
        deferredResult.init(new DeferredResult.DeferredResultHandler(){

            public void handle(Object result) {
                if (AsyncExecutionChain.this.asyncWebRequest.isAsyncCompleted()) {
                    throw new StaleAsyncWebRequestException("Async request processing already completed");
                }
                AsyncExecutionChain.this.setCallable(new PassThroughCallable(result));
                new AsyncExecutionChainRunnable(AsyncExecutionChain.this.asyncWebRequest, AsyncExecutionChain.this.buildChain()).run();
            }
        });
        if (deferredResult.canHandleTimeout()) {
            this.asyncWebRequest.setTimeoutHandler(new Runnable(){

                public void run() {
                    deferredResult.handleTimeout();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PassThroughCallable
    implements Callable<Object> {
        private final Object value;

        public PassThroughCallable(Object value) {
            this.value = value;
        }

        @Override
        public Object call() throws Exception {
            return this.value;
        }
    }
}

