/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.core.Conventions;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.SessionAttributesHandler;
import org.springframework.web.method.support.InvocableHandlerMethod;
import org.springframework.web.method.support.ModelAndViewContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelFactory {
    private final List<InvocableHandlerMethod> attributeMethods;
    private final WebDataBinderFactory binderFactory;
    private final SessionAttributesHandler sessionAttributesHandler;

    public ModelFactory(List<InvocableHandlerMethod> attributeMethods, WebDataBinderFactory binderFactory, SessionAttributesHandler sessionAttributesHandler) {
        this.attributeMethods = attributeMethods != null ? attributeMethods : new ArrayList();
        this.binderFactory = binderFactory;
        this.sessionAttributesHandler = sessionAttributesHandler;
    }

    public void initModel(NativeWebRequest request, ModelAndViewContainer mavContainer, HandlerMethod handlerMethod) throws Exception {
        Map<String, Object> sessionAttrs = this.sessionAttributesHandler.retrieveAttributes(request);
        mavContainer.mergeAttributes(sessionAttrs);
        this.invokeModelAttributeMethods(request, mavContainer);
        this.checkHandlerSessionAttributes(request, mavContainer, handlerMethod);
    }

    private void invokeModelAttributeMethods(NativeWebRequest request, ModelAndViewContainer mavContainer) throws Exception {
        for (InvocableHandlerMethod attrMethod : this.attributeMethods) {
            String returnValueName;
            String modelName = attrMethod.getMethodAnnotation(ModelAttribute.class).value();
            if (mavContainer.containsAttribute(modelName)) continue;
            Object returnValue = attrMethod.invokeForRequest(request, mavContainer, new Object[0]);
            if (attrMethod.isVoid() || mavContainer.containsAttribute(returnValueName = ModelFactory.getNameForReturnValue(returnValue, attrMethod.getReturnType()))) continue;
            mavContainer.addAttribute(returnValueName, returnValue);
        }
    }

    private void checkHandlerSessionAttributes(NativeWebRequest request, ModelAndViewContainer mavContainer, HandlerMethod handlerMethod) throws HttpSessionRequiredException {
        MethodParameter[] methodParameterArray = handlerMethod.getMethodParameters();
        int n = methodParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attrName;
            MethodParameter parameter = methodParameterArray[n2];
            if (parameter.hasParameterAnnotation(ModelAttribute.class) && !mavContainer.containsAttribute(attrName = ModelFactory.getNameForParameter(parameter)) && this.sessionAttributesHandler.isHandlerSessionAttribute(attrName, parameter.getParameterType())) {
                Object attrValue = this.sessionAttributesHandler.retrieveAttribute(request, attrName);
                if (attrValue == null) {
                    throw new HttpSessionRequiredException("Session attribute '" + attrName + "' not found in session: " + handlerMethod);
                }
                mavContainer.addAttribute(attrName, attrValue);
            }
            ++n2;
        }
    }

    public static String getNameForReturnValue(Object returnValue, MethodParameter returnType) {
        ModelAttribute annot = (ModelAttribute)returnType.getMethodAnnotation(ModelAttribute.class);
        if (annot != null && StringUtils.hasText((String)annot.value())) {
            return annot.value();
        }
        Method method = returnType.getMethod();
        Class resolvedType = GenericTypeResolver.resolveReturnType((Method)method, (Class)returnType.getDeclaringClass());
        return Conventions.getVariableNameForReturnType((Method)method, (Class)resolvedType, (Object)returnValue);
    }

    public static String getNameForParameter(MethodParameter parameter) {
        ModelAttribute annot = (ModelAttribute)parameter.getParameterAnnotation(ModelAttribute.class);
        String attrName = annot != null ? annot.value() : null;
        return StringUtils.hasText((String)attrName) ? attrName : Conventions.getVariableNameForParameter((MethodParameter)parameter);
    }

    public void updateModel(NativeWebRequest request, ModelAndViewContainer mavContainer) throws Exception {
        if (mavContainer.getSessionStatus().isComplete()) {
            this.sessionAttributesHandler.cleanupAttributes(request);
        } else {
            this.sessionAttributesHandler.storeAttributes(request, (Map<String, ?>)mavContainer.getModel());
        }
        if (!mavContainer.isRequestHandled()) {
            this.updateBindingResult(request, mavContainer.getModel());
        }
    }

    private void updateBindingResult(NativeWebRequest request, ModelMap model) throws Exception {
        ArrayList keyNames = new ArrayList(model.keySet());
        for (String name : keyNames) {
            String bindingResultKey;
            Object value;
            if (!this.isBindingCandidate(name, value = model.get((Object)name)) || model.containsAttribute(bindingResultKey = String.valueOf(BindingResult.MODEL_KEY_PREFIX) + name)) continue;
            WebDataBinder dataBinder = this.binderFactory.createBinder(request, value, name);
            model.put((Object)bindingResultKey, (Object)dataBinder.getBindingResult());
        }
    }

    private boolean isBindingCandidate(String attributeName, Object value) {
        Class<?> attrType;
        if (attributeName.startsWith(BindingResult.MODEL_KEY_PREFIX)) {
            return false;
        }
        Class<?> clazz = attrType = value != null ? value.getClass() : null;
        if (this.sessionAttributesHandler.isHandlerSessionAttribute(attributeName, attrType)) {
            return true;
        }
        return value != null && !value.getClass().isArray() && !(value instanceof Collection) && !(value instanceof Map) && !BeanUtils.isSimpleValueType(value.getClass());
    }
}

