/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation.support;

import java.lang.annotation.Annotation;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.bind.support.WebRequestDataBinder;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.ModelFactory;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ModelAttributeMethodProcessor
implements HandlerMethodArgumentResolver,
HandlerMethodReturnValueHandler {
    private final boolean useDefaultResolution;

    public ModelAttributeMethodProcessor(boolean useDefaultResolution) {
        this.useDefaultResolution = useDefaultResolution;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(ModelAttribute.class)) {
            return true;
        }
        if (this.useDefaultResolution) {
            return !BeanUtils.isSimpleProperty((Class)parameter.getParameterType());
        }
        return false;
    }

    public final Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        WebDataBinder binder = this.createDataBinder(parameter, mavContainer, webRequest, binderFactory);
        if (binder.getTarget() != null) {
            this.doBind(binder, webRequest);
            if (this.shouldValidate(binder, parameter)) {
                binder.validate();
            }
            if (this.failOnError(binder, parameter) && binder.getBindingResult().hasErrors()) {
                throw new BindException(binder.getBindingResult());
            }
        }
        mavContainer.addAllAttributes(binder.getBindingResult().getModel());
        return binder.getTarget();
    }

    private WebDataBinder createDataBinder(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String attrName = ModelFactory.getNameForParameter(parameter);
        Object target = mavContainer.containsAttribute(attrName) ? mavContainer.getAttribute(attrName) : BeanUtils.instantiateClass((Class)parameter.getParameterType());
        return binderFactory.createBinder(webRequest, target, attrName);
    }

    protected void doBind(WebDataBinder binder, NativeWebRequest request) {
        ((WebRequestDataBinder)binder).bind(request);
    }

    protected boolean shouldValidate(WebDataBinder binder, MethodParameter parameter) {
        Annotation[] annotations;
        Annotation[] annotationArray = annotations = parameter.getParameterAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annot = annotationArray[n2];
            if ("Valid".equals(annot.annotationType().getSimpleName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean failOnError(WebDataBinder binder, MethodParameter parameter) {
        int i = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getMethod().getParameterTypes();
        boolean hasBindingResult = paramTypes.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
        return !hasBindingResult;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return returnType.getMethodAnnotation(ModelAttribute.class) != null;
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (returnValue != null) {
            String name = ModelFactory.getNameForReturnValue(returnValue, returnType);
            mavContainer.addAttribute(name, returnValue);
        }
    }
}

