/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class SimpleTransactionScope
implements Scope {
    public Object get(String name, ObjectFactory<?> objectFactory) {
        Object scopedObject;
        ScopedObjectsHolder scopedObjects = (ScopedObjectsHolder)TransactionSynchronizationManager.getResource(this);
        if (scopedObjects == null) {
            scopedObjects = new ScopedObjectsHolder();
            TransactionSynchronizationManager.registerSynchronization(new CleanupSynchronization(scopedObjects));
            TransactionSynchronizationManager.bindResource(this, scopedObjects);
        }
        if ((scopedObject = scopedObjects.scopedInstances.get(name)) == null) {
            scopedObject = objectFactory.getObject();
            Assert.state((scopedObject != null ? 1 : 0) != 0, (String)"Scoped object resolved to null");
            scopedObjects.scopedInstances.put(name, scopedObject);
        }
        return scopedObject;
    }

    public Object remove(String name) {
        ScopedObjectsHolder scopedObjects = (ScopedObjectsHolder)TransactionSynchronizationManager.getResource(this);
        if (scopedObjects != null) {
            scopedObjects.destructionCallbacks.remove(name);
            return scopedObjects.scopedInstances.remove(name);
        }
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        ScopedObjectsHolder scopedObjects = (ScopedObjectsHolder)TransactionSynchronizationManager.getResource(this);
        if (scopedObjects != null) {
            scopedObjects.destructionCallbacks.put(name, callback);
        }
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return TransactionSynchronizationManager.getCurrentTransactionName();
    }

    private class CleanupSynchronization
    extends TransactionSynchronizationAdapter {
        private final ScopedObjectsHolder scopedObjects;

        public CleanupSynchronization(ScopedObjectsHolder scopedObjects) {
            this.scopedObjects = scopedObjects;
        }

        @Override
        public void suspend() {
            TransactionSynchronizationManager.unbindResource(SimpleTransactionScope.this);
        }

        @Override
        public void resume() {
            TransactionSynchronizationManager.bindResource(SimpleTransactionScope.this, this.scopedObjects);
        }

        @Override
        public void afterCompletion(int status) {
            TransactionSynchronizationManager.unbindResourceIfPossible(SimpleTransactionScope.this);
            for (Runnable callback : this.scopedObjects.destructionCallbacks.values()) {
                callback.run();
            }
            this.scopedObjects.destructionCallbacks.clear();
            this.scopedObjects.scopedInstances.clear();
        }
    }

    static class ScopedObjectsHolder {
        final Map<String, Object> scopedInstances = new HashMap<String, Object>();
        final Map<String, Runnable> destructionCallbacks = new LinkedHashMap<String, Runnable>();

        ScopedObjectsHolder() {
        }
    }
}

