/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.support;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.test.util.XpathExpectationsHelper;
import org.springframework.util.MimeType;

public abstract class AbstractXpathAssertions<B> {
    private final B bodySpec;
    private final XpathExpectationsHelper xpathHelper;

    public AbstractXpathAssertions(B spec, String expression, @Nullable Map<String, String> namespaces, Object ... args) {
        this.bodySpec = spec;
        this.xpathHelper = AbstractXpathAssertions.initXpathHelper(expression, namespaces, args);
    }

    private static XpathExpectationsHelper initXpathHelper(String expression, @Nullable Map<String, String> namespaces, Object[] args) {
        try {
            return new XpathExpectationsHelper(expression, namespaces, args);
        }
        catch (XPathExpressionException ex) {
            throw new AssertionError("XML parsing error", ex);
        }
    }

    protected B getBodySpec() {
        return this.bodySpec;
    }

    protected abstract Optional<HttpHeaders> getResponseHeaders();

    protected abstract byte[] getContent();

    public B isEqualTo(String expectedValue) {
        return this.assertWith(() -> this.xpathHelper.assertString(this.getContent(), this.getCharset(), expectedValue));
    }

    public B isEqualTo(Double expectedValue) {
        return this.assertWith(() -> this.xpathHelper.assertNumber(this.getContent(), this.getCharset(), expectedValue));
    }

    public B isEqualTo(boolean expectedValue) {
        return this.assertWith(() -> this.xpathHelper.assertBoolean(this.getContent(), this.getCharset(), expectedValue));
    }

    public B exists() {
        return this.assertWith(() -> this.xpathHelper.exists(this.getContent(), this.getCharset()));
    }

    public B doesNotExist() {
        return this.assertWith(() -> this.xpathHelper.doesNotExist(this.getContent(), this.getCharset()));
    }

    public B nodeCount(int expectedCount) {
        return this.assertWith(() -> this.xpathHelper.assertNodeCount(this.getContent(), this.getCharset(), expectedCount));
    }

    public B string(Matcher<? super String> matcher) {
        return this.assertWith(() -> this.xpathHelper.assertString(this.getContent(), this.getCharset(), matcher));
    }

    public B number(Matcher<? super Double> matcher) {
        return this.assertWith(() -> this.xpathHelper.assertNumber(this.getContent(), this.getCharset(), matcher));
    }

    public B nodeCount(Matcher<? super Integer> matcher) {
        return this.assertWith(() -> this.xpathHelper.assertNodeCount(this.getContent(), this.getCharset(), matcher));
    }

    public B string(Consumer<String> consumer) {
        return this.assertWith(() -> {
            String value = this.xpathHelper.evaluateXpath(this.getContent(), this.getCharset(), String.class);
            consumer.accept(value);
        });
    }

    public B number(Consumer<Double> consumer) {
        return this.assertWith(() -> {
            Double value = this.xpathHelper.evaluateXpath(this.getContent(), this.getCharset(), Double.class);
            consumer.accept(value);
        });
    }

    public B nodeCount(Consumer<Integer> consumer) {
        return this.assertWith(() -> {
            Integer value = this.xpathHelper.evaluateXpath(this.getContent(), this.getCharset(), Integer.class);
            consumer.accept(value);
        });
    }

    private B assertWith(CheckedExceptionTask task) {
        try {
            task.run();
        }
        catch (Exception ex) {
            throw new AssertionError("XML parsing error", ex);
        }
        return this.bodySpec;
    }

    private String getCharset() {
        return this.getResponseHeaders().map(HttpHeaders::getContentType).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8).name();
    }

    public boolean equals(@Nullable Object obj) {
        throw new AssertionError((Object)"Object#equals is disabled to avoid being used in error instead of XPathAssertions#isEqualTo(String).");
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static interface CheckedExceptionTask {
        public void run() throws Exception;
    }
}

