/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.AttributeAccessor;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.MethodInvoker;

public interface TestContext
extends AttributeAccessor,
Serializable {
    default public boolean hasApplicationContext() {
        return false;
    }

    public ApplicationContext getApplicationContext();

    default public void publishEvent(Function<TestContext, ? extends ApplicationEvent> eventFactory) {
        if (this.hasApplicationContext()) {
            this.getApplicationContext().publishEvent(eventFactory.apply(this));
        }
    }

    public Class<?> getTestClass();

    public Object getTestInstance();

    public Method getTestMethod();

    public @Nullable Throwable getTestException();

    default public void markApplicationContextUnused() {
    }

    public void markApplicationContextDirty(@Nullable DirtiesContext.HierarchyMode var1);

    public void updateState(@Nullable Object var1, @Nullable Method var2, @Nullable Throwable var3);

    default public void setMethodInvoker(MethodInvoker methodInvoker) {
    }

    default public MethodInvoker getMethodInvoker() {
        return MethodInvoker.DEFAULT_INVOKER;
    }
}

