/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web.socket;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.context.web.socket.MockServerContainerContextCustomizer;
import org.springframework.util.ClassUtils;

class MockServerContainerContextCustomizerFactory
implements ContextCustomizerFactory {
    private static final boolean webSocketPresent = ClassUtils.isPresent((String)"jakarta.websocket.server.ServerContainer", (ClassLoader)MockServerContainerContextCustomizerFactory.class.getClassLoader());

    MockServerContainerContextCustomizerFactory() {
    }

    @Override
    public @Nullable ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        if (webSocketPresent && MockServerContainerContextCustomizerFactory.isAnnotatedWithWebAppConfiguration(testClass)) {
            return new MockServerContainerContextCustomizer();
        }
        return null;
    }

    private static boolean isAnnotatedWithWebAppConfiguration(Class<?> testClass) {
        return TestContextAnnotationUtils.hasAnnotation(testClass, WebAppConfiguration.class);
    }
}

