/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import com.jayway.jsonpath.Configuration;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.lang.Nullable;
import org.springframework.test.util.JsonPathExpectationsHelper;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.Assert;

public class JsonPathAssertions {
    private final WebTestClient.BodyContentSpec bodySpec;
    private final String content;
    private final JsonPathExpectationsHelper pathHelper;

    JsonPathAssertions(WebTestClient.BodyContentSpec spec, String content, String expression, @Nullable Configuration configuration) {
        Assert.hasText((String)expression, (String)"expression must not be null or empty");
        this.bodySpec = spec;
        this.content = content;
        this.pathHelper = new JsonPathExpectationsHelper(expression, configuration);
    }

    public WebTestClient.BodyContentSpec isEqualTo(Object expectedValue) {
        this.pathHelper.assertValue(this.content, expectedValue);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec exists() {
        this.pathHelper.exists(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec doesNotExist() {
        this.pathHelper.doesNotExist(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isEmpty() {
        this.pathHelper.assertValueIsEmpty(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isNotEmpty() {
        this.pathHelper.assertValueIsNotEmpty(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec hasJsonPath() {
        this.pathHelper.hasJsonPath(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec doesNotHaveJsonPath() {
        this.pathHelper.doesNotHaveJsonPath(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isBoolean() {
        this.pathHelper.assertValueIsBoolean(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isNumber() {
        this.pathHelper.assertValueIsNumber(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isArray() {
        this.pathHelper.assertValueIsArray(this.content);
        return this.bodySpec;
    }

    public WebTestClient.BodyContentSpec isMap() {
        this.pathHelper.assertValueIsMap(this.content);
        return this.bodySpec;
    }

    public <T> WebTestClient.BodyContentSpec value(Matcher<? super T> matcher) {
        this.pathHelper.assertValue(this.content, matcher);
        return this.bodySpec;
    }

    public <T> WebTestClient.BodyContentSpec value(Class<T> targetType, Matcher<? super T> matcher) {
        this.pathHelper.assertValue(this.content, matcher, targetType);
        return this.bodySpec;
    }

    @Deprecated(since="6.2", forRemoval=true)
    public <T> WebTestClient.BodyContentSpec value(Matcher<? super T> matcher, Class<T> targetType) {
        this.pathHelper.assertValue(this.content, matcher, targetType);
        return this.bodySpec;
    }

    public <T> WebTestClient.BodyContentSpec value(ParameterizedTypeReference<T> targetType, Matcher<? super T> matcher) {
        this.pathHelper.assertValue(this.content, matcher, targetType);
        return this.bodySpec;
    }

    public <T> WebTestClient.BodyContentSpec value(Consumer<T> consumer) {
        Object value = this.pathHelper.evaluateJsonPath(this.content);
        consumer.accept(value);
        return this.bodySpec;
    }

    public <T> WebTestClient.BodyContentSpec value(Class<T> targetType, Consumer<T> consumer) {
        T value = this.pathHelper.evaluateJsonPath(this.content, targetType);
        consumer.accept(value);
        return this.bodySpec;
    }

    @Deprecated(since="6.2", forRemoval=true)
    public <T> WebTestClient.BodyContentSpec value(Consumer<T> consumer, Class<T> targetType) {
        return this.value(targetType, consumer);
    }

    public <T> WebTestClient.BodyContentSpec value(ParameterizedTypeReference<T> targetType, Consumer<T> consumer) {
        T value = this.pathHelper.evaluateJsonPath(this.content, targetType);
        consumer.accept(value);
        return this.bodySpec;
    }

    public boolean equals(@Nullable Object obj) {
        throw new AssertionError((Object)"Object#equals is disabled to avoid being used in error instead of JsonPathAssertions#isEqualTo(String).");
    }

    public int hashCode() {
        return super.hashCode();
    }
}

