/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.bean.override.BeanOverride;
import org.springframework.test.context.bean.override.BeanOverrideProcessor;
import org.springframework.test.context.bean.override.BeanOverrideStrategy;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class BeanOverrideHandler {
    private static final Comparator<MergedAnnotation<? extends Annotation>> reversedMetaDistance = Comparator.comparingInt(MergedAnnotation::getDistance).reversed();
    @Nullable
    private final Field field;
    private final Set<Annotation> qualifierAnnotations;
    private final ResolvableType beanType;
    @Nullable
    private final String beanName;
    private final BeanOverrideStrategy strategy;

    protected BeanOverrideHandler(@Nullable Field field, ResolvableType beanType, @Nullable String beanName, BeanOverrideStrategy strategy) {
        this.field = field;
        this.qualifierAnnotations = BeanOverrideHandler.getQualifierAnnotations(field);
        this.beanType = beanType;
        this.beanName = beanName;
        this.strategy = strategy;
    }

    public static List<BeanOverrideHandler> forTestClass(Class<?> testClass) {
        return BeanOverrideHandler.findHandlers(testClass, true);
    }

    static List<BeanOverrideHandler> findAllHandlers(Class<?> testClass) {
        return BeanOverrideHandler.findHandlers(testClass, false);
    }

    private static List<BeanOverrideHandler> findHandlers(Class<?> testClass, boolean localFieldsOnly) {
        ArrayList<BeanOverrideHandler> handlers = new ArrayList<BeanOverrideHandler>();
        BeanOverrideHandler.findHandlers(testClass, testClass, handlers, localFieldsOnly);
        return handlers;
    }

    private static void findHandlers(Class<?> clazz, Class<?> testClass, List<BeanOverrideHandler> handlers, boolean localFieldsOnly) {
        Class<?> superclass;
        if (!localFieldsOnly && TestContextAnnotationUtils.searchEnclosingClass(clazz)) {
            BeanOverrideHandler.findHandlers(clazz.getEnclosingClass(), testClass, handlers, localFieldsOnly);
        }
        if ((superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
            BeanOverrideHandler.findHandlers(superclass, testClass, handlers, localFieldsOnly);
        }
        if (!localFieldsOnly) {
            for (Class<?> ifc : clazz.getInterfaces()) {
                BeanOverrideHandler.findHandlers(ifc, testClass, handlers, localFieldsOnly);
            }
            BeanOverrideHandler.processClass(clazz, testClass, handlers);
        }
        ReflectionUtils.doWithLocalFields(clazz, field -> BeanOverrideHandler.processField(field, testClass, handlers));
    }

    private static void processClass(Class<?> clazz, Class<?> testClass, List<BeanOverrideHandler> handlers) {
        BeanOverrideHandler.processElement(clazz, testClass, (processor, composedAnnotation) -> processor.createHandlers((Annotation)composedAnnotation, testClass).forEach(handlers::add));
    }

    private static void processField(Field field, Class<?> testClass, List<BeanOverrideHandler> handlers) {
        AtomicBoolean overrideAnnotationFound = new AtomicBoolean();
        BeanOverrideHandler.processElement(field, testClass, (processor, composedAnnotation) -> {
            Assert.state((!Modifier.isStatic(field.getModifiers()) ? 1 : 0) != 0, () -> "@BeanOverride field must not be static: " + field);
            Assert.state((boolean)overrideAnnotationFound.compareAndSet(false, true), () -> "Multiple @BeanOverride annotations found on field: " + field);
            handlers.add(processor.createHandler((Annotation)composedAnnotation, testClass, field));
        });
    }

    private static void processElement(AnnotatedElement element, Class<?> testClass, BiConsumer<BeanOverrideProcessor, Annotation> consumer) {
        MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.DIRECT).stream(BeanOverride.class).sorted(reversedMetaDistance).forEach(mergedAnnotation -> {
            MergedAnnotation metaSource = mergedAnnotation.getMetaSource();
            Assert.state((metaSource != null ? 1 : 0) != 0, (String)"@BeanOverride annotation must be meta-present");
            BeanOverride beanOverride = (BeanOverride)mergedAnnotation.synthesize();
            BeanOverrideProcessor processor = (BeanOverrideProcessor)BeanUtils.instantiateClass(beanOverride.value());
            Annotation composedAnnotation = metaSource.synthesize();
            consumer.accept(processor, composedAnnotation);
        });
    }

    @Nullable
    public final Field getField() {
        return this.field;
    }

    public final ResolvableType getBeanType() {
        return this.beanType;
    }

    @Nullable
    public final String getBeanName() {
        return this.beanName;
    }

    public final BeanOverrideStrategy getStrategy() {
        return this.strategy;
    }

    final Object createOverrideInstance(String beanName, @Nullable BeanDefinition existingBeanDefinition, @Nullable Object existingBeanInstance, SingletonBeanRegistry singletonBeanRegistry) {
        Object override = this.createOverrideInstance(beanName, existingBeanDefinition, existingBeanInstance);
        this.trackOverrideInstance(override, singletonBeanRegistry);
        return override;
    }

    protected abstract Object createOverrideInstance(String var1, @Nullable BeanDefinition var2, @Nullable Object var3);

    protected void trackOverrideInstance(Object override, SingletonBeanRegistry singletonBeanRegistry) {
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        BeanOverrideHandler that = (BeanOverrideHandler)other;
        if (!(Objects.equals(this.beanType.getType(), that.beanType.getType()) && Objects.equals(this.beanName, that.beanName) && Objects.equals((Object)this.strategy, (Object)that.strategy))) {
            return false;
        }
        if (this.beanName != null) {
            return true;
        }
        if (this.field == null) {
            return that.field == null;
        }
        return that.field != null && this.field.getName().equals(that.field.getName()) && this.qualifierAnnotations.equals(that.qualifierAnnotations);
    }

    public int hashCode() {
        int hash = Objects.hash(new Object[]{this.getClass(), this.beanType.getType(), this.beanName, this.strategy});
        return this.beanName != null ? hash : hash + Objects.hash(this.field != null ? this.field.getName() : null, this.qualifierAnnotations);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("field", (Object)this.field).append("beanType", (Object)this.beanType).append("beanName", (Object)this.beanName).append("strategy", (Object)this.strategy).toString();
    }

    private static Set<Annotation> getQualifierAnnotations(@Nullable Field field) {
        if (field == null) {
            return Collections.emptySet();
        }
        Annotation[] candidates = field.getDeclaredAnnotations();
        if (candidates.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Annotation> annotations = new HashSet<Annotation>(candidates.length - 1);
        for (Annotation candidate : candidates) {
            if (BeanOverrideHandler.isBeanOverrideAnnotation(candidate.annotationType())) continue;
            annotations.add(candidate);
        }
        return annotations;
    }

    private static boolean isBeanOverrideAnnotation(Class<? extends Annotation> type) {
        return MergedAnnotations.from(type).isPresent(BeanOverride.class);
    }
}

