/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.lang.Nullable;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.util.ClassUtils;

abstract class BootstrapUtils {
    private static final String DEFAULT_BOOTSTRAP_CONTEXT_CLASS_NAME = "org.springframework.test.context.support.DefaultBootstrapContext";
    private static final String DEFAULT_CACHE_AWARE_CONTEXT_LOADER_DELEGATE_CLASS_NAME = "org.springframework.test.context.cache.DefaultCacheAwareContextLoaderDelegate";
    private static final String DEFAULT_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME = "org.springframework.test.context.support.DefaultTestContextBootstrapper";
    private static final String DEFAULT_WEB_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME = "org.springframework.test.context.web.WebTestContextBootstrapper";
    private static final String WEB_APP_CONFIGURATION_ANNOTATION_CLASS_NAME = "org.springframework.test.context.web.WebAppConfiguration";
    private static final Class<? extends Annotation> webAppConfigurationClass = BootstrapUtils.loadWebAppConfigurationClass();
    private static final Log logger = LogFactory.getLog(BootstrapUtils.class);

    BootstrapUtils() {
    }

    static BootstrapContext createBootstrapContext(Class<?> testClass) {
        CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate = BootstrapUtils.createCacheAwareContextLoaderDelegate();
        Class clazz = null;
        try {
            clazz = ClassUtils.forName((String)DEFAULT_BOOTSTRAP_CONTEXT_CLASS_NAME, (ClassLoader)BootstrapUtils.class.getClassLoader());
            Constructor constructor = clazz.getConstructor(Class.class, CacheAwareContextLoaderDelegate.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Instantiating BootstrapContext using constructor [%s]", constructor));
            }
            return (BootstrapContext)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{testClass, cacheAwareContextLoaderDelegate});
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Could not load BootstrapContext [" + clazz + "]", ex);
        }
    }

    private static CacheAwareContextLoaderDelegate createCacheAwareContextLoaderDelegate() {
        Class clazz = null;
        try {
            clazz = ClassUtils.forName((String)DEFAULT_CACHE_AWARE_CONTEXT_LOADER_DELEGATE_CLASS_NAME, (ClassLoader)BootstrapUtils.class.getClassLoader());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Instantiating CacheAwareContextLoaderDelegate from class [%s]", clazz.getName()));
            }
            return (CacheAwareContextLoaderDelegate)BeanUtils.instantiateClass((Class)clazz, CacheAwareContextLoaderDelegate.class);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Could not load CacheAwareContextLoaderDelegate [" + clazz + "]", ex);
        }
    }

    static TestContextBootstrapper resolveTestContextBootstrapper(BootstrapContext bootstrapContext) {
        Class<?> testClass = bootstrapContext.getTestClass();
        Class<?> clazz = null;
        try {
            clazz = BootstrapUtils.resolveExplicitTestContextBootstrapper(testClass);
            if (clazz == null) {
                clazz = BootstrapUtils.resolveDefaultTestContextBootstrapper(testClass);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Instantiating TestContextBootstrapper for test class [%s] from class [%s]", testClass.getName(), clazz.getName()));
            }
            TestContextBootstrapper testContextBootstrapper = (TestContextBootstrapper)BeanUtils.instantiateClass(clazz, TestContextBootstrapper.class);
            testContextBootstrapper.setBootstrapContext(bootstrapContext);
            return testContextBootstrapper;
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Could not load TestContextBootstrapper [" + clazz + "]. Specify @BootstrapWith's 'value' attribute or make the default bootstrapper class available.", ex);
        }
    }

    @Nullable
    private static Class<?> resolveExplicitTestContextBootstrapper(Class<?> testClass) {
        LinkedHashSet<BootstrapWith> annotations = new LinkedHashSet<BootstrapWith>();
        for (TestContextAnnotationUtils.AnnotationDescriptor<BootstrapWith> descriptor = TestContextAnnotationUtils.findAnnotationDescriptor(testClass, BootstrapWith.class); descriptor != null; descriptor = descriptor.next()) {
            annotations.addAll(descriptor.findAllLocalMergedAnnotations());
        }
        if (annotations.isEmpty()) {
            return null;
        }
        if (annotations.size() == 1) {
            return ((BootstrapWith)annotations.iterator().next()).value();
        }
        BootstrapWith bootstrapWith = testClass.getDeclaredAnnotation(BootstrapWith.class);
        if (bootstrapWith != null) {
            return bootstrapWith.value();
        }
        throw new IllegalStateException(String.format("Configuration error: found multiple declarations of @BootstrapWith for test class [%s]: %s", testClass.getName(), annotations));
    }

    private static Class<?> resolveDefaultTestContextBootstrapper(Class<?> testClass) throws Exception {
        boolean webApp = TestContextAnnotationUtils.hasAnnotation(testClass, webAppConfigurationClass);
        String bootstrapperClassName = webApp ? DEFAULT_WEB_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME : DEFAULT_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME;
        return ClassUtils.forName((String)bootstrapperClassName, (ClassLoader)BootstrapUtils.class.getClassLoader());
    }

    private static Class<? extends Annotation> loadWebAppConfigurationClass() {
        try {
            return ClassUtils.forName((String)WEB_APP_CONFIGURATION_ANNOTATION_CLASS_NAME, (ClassLoader)BootstrapUtils.class.getClassLoader());
        }
        catch (ClassNotFoundException | LinkageError ex) {
            throw new IllegalStateException("Failed to load class for @org.springframework.test.context.web.WebAppConfiguration", ex);
        }
    }
}

