/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import java.util.Set;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class WebMergedContextConfiguration
extends MergedContextConfiguration {
    private static final long serialVersionUID = 7323361588604247458L;
    private final String resourceBasePath;

    public WebMergedContextConfiguration(MergedContextConfiguration mergedConfig, String resourceBasePath) {
        super(mergedConfig);
        this.resourceBasePath = !StringUtils.hasText((String)resourceBasePath) ? "" : resourceBasePath;
    }

    public WebMergedContextConfiguration(Class<?> testClass, @Nullable String[] locations, @Nullable Class<?>[] classes, @Nullable Set<Class<? extends ApplicationContextInitializer<?>>> contextInitializerClasses, @Nullable String[] activeProfiles, @Nullable String[] propertySourceLocations, @Nullable String[] propertySourceProperties, String resourceBasePath, ContextLoader contextLoader, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, @Nullable MergedContextConfiguration parent) {
        this(testClass, locations, classes, contextInitializerClasses, activeProfiles, propertySourceLocations, propertySourceProperties, null, resourceBasePath, contextLoader, cacheAwareContextLoaderDelegate, parent);
    }

    public WebMergedContextConfiguration(Class<?> testClass, @Nullable String[] locations, @Nullable Class<?>[] classes, @Nullable Set<Class<? extends ApplicationContextInitializer<?>>> contextInitializerClasses, @Nullable String[] activeProfiles, @Nullable String[] propertySourceLocations, @Nullable String[] propertySourceProperties, @Nullable Set<ContextCustomizer> contextCustomizers, String resourceBasePath, ContextLoader contextLoader, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, @Nullable MergedContextConfiguration parent) {
        super(testClass, locations, classes, contextInitializerClasses, activeProfiles, propertySourceLocations, propertySourceProperties, contextCustomizers, contextLoader, cacheAwareContextLoaderDelegate, parent);
        this.resourceBasePath = StringUtils.hasText((String)resourceBasePath) ? resourceBasePath : "";
    }

    public String getResourceBasePath() {
        return this.resourceBasePath;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || super.equals(other) && this.resourceBasePath.equals(((WebMergedContextConfiguration)other).resourceBasePath);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.resourceBasePath.hashCode();
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this).append("testClass", this.getTestClass()).append("locations", (Object)ObjectUtils.nullSafeToString((Object[])this.getLocations())).append("classes", (Object)ObjectUtils.nullSafeToString((Object[])this.getClasses())).append("contextInitializerClasses", (Object)ObjectUtils.nullSafeToString(this.getContextInitializerClasses())).append("activeProfiles", (Object)ObjectUtils.nullSafeToString((Object[])this.getActiveProfiles())).append("propertySourceLocations", (Object)ObjectUtils.nullSafeToString((Object[])this.getPropertySourceLocations())).append("propertySourceProperties", (Object)ObjectUtils.nullSafeToString((Object[])this.getPropertySourceProperties())).append("contextCustomizers", this.getContextCustomizers()).append("resourceBasePath", (Object)this.getResourceBasePath()).append("contextLoader", (Object)WebMergedContextConfiguration.nullSafeClassName(this.getContextLoader())).append("parent", (Object)this.getParent()).toString();
    }
}

