/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import org.springframework.util.Assert;

@Deprecated
public abstract class AssertThrows {
    private final Class<? extends Throwable> expectedException;
    private String failureMessage;
    private Throwable actualException;

    public AssertThrows(Class<? extends Throwable> expectedException) {
        this(expectedException, null);
    }

    public AssertThrows(Class<? extends Throwable> expectedException, String failureMessage) {
        Assert.notNull(expectedException, (String)"expectedException is required");
        Assert.isAssignable(Throwable.class, expectedException, (String)"expectedException: ");
        this.expectedException = expectedException;
        this.failureMessage = failureMessage;
    }

    protected Class<? extends Throwable> getExpectedException() {
        return this.expectedException;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    protected String getFailureMessage() {
        return this.failureMessage;
    }

    public abstract void test() throws Throwable;

    public void runTest() {
        try {
            this.test();
            this.doFail();
        }
        catch (Throwable actualException) {
            this.actualException = actualException;
            this.checkExceptionExpectations(actualException);
        }
    }

    protected void doFail() {
        throw new AssertionError((Object)this.createMessageForNoExceptionThrown());
    }

    protected String createMessageForNoExceptionThrown() {
        StringBuilder sb = new StringBuilder();
        sb.append("Should have thrown a [").append(this.getExpectedException()).append("]");
        if (this.getFailureMessage() != null) {
            sb.append(": ").append(this.getFailureMessage());
        }
        return sb.toString();
    }

    protected void checkExceptionExpectations(Throwable actualException) {
        if (!this.getExpectedException().isAssignableFrom(actualException.getClass())) {
            AssertionError error = new AssertionError((Object)this.createMessageForWrongThrownExceptionType(actualException));
            ((Throwable)((Object)error)).initCause(actualException);
            throw error;
        }
    }

    protected String createMessageForWrongThrownExceptionType(Throwable actualException) {
        StringBuilder sb = new StringBuilder();
        sb.append("Was expecting a [").append(this.getExpectedException().getName());
        sb.append("] to be thrown, but instead a [").append(actualException.getClass().getName());
        sb.append("] was thrown.");
        return sb.toString();
    }

    public final Throwable getActualException() {
        return this.actualException;
    }
}

