/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.Fail;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.test.annotation.Repeat;
import org.springframework.test.annotation.Timed;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit4.statements.RunAfterTestClassCallbacks;
import org.springframework.test.context.junit4.statements.RunAfterTestMethodCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestClassCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestMethodCallbacks;
import org.springframework.test.context.junit4.statements.SpringFailOnTimeout;
import org.springframework.test.context.junit4.statements.SpringRepeat;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringJUnit4ClassRunner
extends BlockJUnit4ClassRunner {
    private static final Log logger = LogFactory.getLog(SpringJUnit4ClassRunner.class);
    private final TestContextManager testContextManager;

    public SpringJUnit4ClassRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SpringJUnit4ClassRunner constructor called with [" + clazz + "]."));
        }
        this.testContextManager = this.createTestContextManager(clazz);
    }

    protected TestContextManager createTestContextManager(Class<?> clazz) {
        return new TestContextManager(clazz, this.getDefaultContextLoaderClassName(clazz));
    }

    protected final TestContextManager getTestContextManager() {
        return this.testContextManager;
    }

    protected String getDefaultContextLoaderClassName(Class<?> clazz) {
        return null;
    }

    public Description getDescription() {
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment(this.getTestClass().getJavaClass())) {
            return Description.createSuiteDescription((Class)this.getTestClass().getJavaClass());
        }
        return super.getDescription();
    }

    public void run(RunNotifier notifier) {
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment(this.getTestClass().getJavaClass())) {
            notifier.fireTestIgnored(this.getDescription());
            return;
        }
        super.run(notifier);
    }

    protected Statement withBeforeClasses(Statement statement) {
        Statement junitBeforeClasses = super.withBeforeClasses(statement);
        return new RunBeforeTestClassCallbacks(junitBeforeClasses, this.getTestContextManager());
    }

    protected Statement withAfterClasses(Statement statement) {
        Statement junitAfterClasses = super.withAfterClasses(statement);
        return new RunAfterTestClassCallbacks(junitAfterClasses, this.getTestContextManager());
    }

    protected Object createTest() throws Exception {
        Object testInstance = super.createTest();
        this.getTestContextManager().prepareTestInstance(testInstance);
        return testInstance;
    }

    protected void runChild(FrameworkMethod frameworkMethod, RunNotifier notifier) {
        EachTestNotifier eachNotifier = this.springMakeNotifier(frameworkMethod, notifier);
        if (this.isTestMethodIgnored(frameworkMethod)) {
            eachNotifier.fireTestIgnored();
            return;
        }
        eachNotifier.fireTestStarted();
        try {
            try {
                this.methodBlock(frameworkMethod).evaluate();
            }
            catch (AssumptionViolatedException e) {
                eachNotifier.addFailedAssumption(e);
                eachNotifier.fireTestFinished();
            }
            catch (Throwable e) {
                eachNotifier.addFailure(e);
                eachNotifier.fireTestFinished();
            }
        }
        finally {
            eachNotifier.fireTestFinished();
        }
    }

    private EachTestNotifier springMakeNotifier(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        return new EachTestNotifier(notifier, description);
    }

    protected Statement methodBlock(FrameworkMethod frameworkMethod) {
        Object testInstance;
        try {
            testInstance = new ReflectiveCallable(){

                protected Object runReflectiveCall() throws Throwable {
                    return SpringJUnit4ClassRunner.this.createTest();
                }
            }.run();
        }
        catch (Throwable ex) {
            return new Fail(ex);
        }
        Statement statement = this.methodInvoker(frameworkMethod, testInstance);
        statement = this.possiblyExpectingExceptions(frameworkMethod, testInstance, statement);
        statement = this.withBefores(frameworkMethod, testInstance, statement);
        statement = this.withAfters(frameworkMethod, testInstance, statement);
        statement = this.withRulesReflectively(frameworkMethod, testInstance, statement);
        statement = this.withPotentialRepeat(frameworkMethod, testInstance, statement);
        statement = this.withPotentialTimeout(frameworkMethod, testInstance, statement);
        return statement;
    }

    private Statement withRulesReflectively(FrameworkMethod frameworkMethod, Object testInstance, Statement statement) {
        Method withRulesMethod = ReflectionUtils.findMethod(((Object)((Object)this)).getClass(), (String)"withRules", (Class[])new Class[]{FrameworkMethod.class, Object.class, Statement.class});
        if (withRulesMethod != null) {
            ReflectionUtils.makeAccessible((Method)withRulesMethod);
            statement = (Statement)ReflectionUtils.invokeMethod((Method)withRulesMethod, (Object)((Object)this), (Object[])new Object[]{frameworkMethod, testInstance, statement});
        }
        return statement;
    }

    protected boolean isTestMethodIgnored(FrameworkMethod frameworkMethod) {
        Method method = frameworkMethod.getMethod();
        return method.isAnnotationPresent(Ignore.class) || !ProfileValueUtils.isTestEnabledInThisEnvironment(method, this.getTestClass().getJavaClass());
    }

    protected Statement possiblyExpectingExceptions(FrameworkMethod frameworkMethod, Object testInstance, Statement next) {
        Class<? extends Throwable> expectedException = this.getExpectedException(frameworkMethod);
        return expectedException != null ? new ExpectException(next, expectedException) : next;
    }

    protected Class<? extends Throwable> getExpectedException(FrameworkMethod frameworkMethod) {
        Class springExpectedException;
        Test testAnnotation = (Test)frameworkMethod.getAnnotation(Test.class);
        Class junitExpectedException = testAnnotation != null && testAnnotation.expected() != Test.None.class ? testAnnotation.expected() : null;
        ExpectedException expectedExAnn = (ExpectedException)frameworkMethod.getAnnotation(ExpectedException.class);
        Class clazz = springExpectedException = expectedExAnn != null ? expectedExAnn.value() : null;
        if (springExpectedException != null && junitExpectedException != null) {
            String msg = "Test method [" + frameworkMethod.getMethod() + "] has been configured with Spring's @ExpectedException(" + springExpectedException.getName() + ".class) and JUnit's @Test(expected=" + junitExpectedException.getName() + ".class) annotations. " + "Only one declaration of an 'expected exception' is permitted per test method.";
            logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        return springExpectedException != null ? springExpectedException : junitExpectedException;
    }

    protected Statement withPotentialTimeout(FrameworkMethod frameworkMethod, Object testInstance, Statement next) {
        Object statement = null;
        long springTimeout = this.getSpringTimeout(frameworkMethod);
        long junitTimeout = this.getJUnitTimeout(frameworkMethod);
        if (springTimeout > 0L && junitTimeout > 0L) {
            String msg = "Test method [" + frameworkMethod.getMethod() + "] has been configured with Spring's @Timed(millis=" + springTimeout + ") and JUnit's @Test(timeout=" + junitTimeout + ") annotations. Only one declaration of a 'timeout' is permitted per test method.";
            logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        statement = springTimeout > 0L ? new SpringFailOnTimeout(next, springTimeout) : (junitTimeout > 0L ? new FailOnTimeout(next, junitTimeout) : next);
        return statement;
    }

    protected long getJUnitTimeout(FrameworkMethod frameworkMethod) {
        Test testAnnotation = (Test)frameworkMethod.getAnnotation(Test.class);
        return testAnnotation != null && testAnnotation.timeout() > 0L ? testAnnotation.timeout() : 0L;
    }

    protected long getSpringTimeout(FrameworkMethod frameworkMethod) {
        Timed timedAnnotation = (Timed)frameworkMethod.getAnnotation(Timed.class);
        return timedAnnotation != null && timedAnnotation.millis() > 0L ? timedAnnotation.millis() : 0L;
    }

    protected Statement withBefores(FrameworkMethod frameworkMethod, Object testInstance, Statement statement) {
        Statement junitBefores = super.withBefores(frameworkMethod, testInstance, statement);
        return new RunBeforeTestMethodCallbacks(junitBefores, testInstance, frameworkMethod.getMethod(), this.getTestContextManager());
    }

    protected Statement withAfters(FrameworkMethod frameworkMethod, Object testInstance, Statement statement) {
        Statement junitAfters = super.withAfters(frameworkMethod, testInstance, statement);
        return new RunAfterTestMethodCallbacks(junitAfters, testInstance, frameworkMethod.getMethod(), this.getTestContextManager());
    }

    protected Statement withPotentialRepeat(FrameworkMethod frameworkMethod, Object testInstance, Statement next) {
        Repeat repeatAnnotation = (Repeat)frameworkMethod.getAnnotation(Repeat.class);
        int repeat = repeatAnnotation != null ? repeatAnnotation.value() : 1;
        return new SpringRepeat(next, frameworkMethod.getMethod(), repeat);
    }
}

