/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit38;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.annotation.ProfileValueSource;
import org.springframework.test.annotation.ProfileValueUtils;
import org.springframework.test.annotation.Repeat;
import org.springframework.test.annotation.Timed;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;

@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class, DirtiesContextTestExecutionListener.class})
public class AbstractJUnit38SpringContextTests
extends TestCase
implements ApplicationContextAware {
    private static int disabledTestCount = 0;
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected ApplicationContext applicationContext;
    protected final ProfileValueSource profileValueSource;
    private final TestContextManager testContextManager = new TestContextManager(((Object)((Object)this)).getClass());

    public static int getDisabledTestCount() {
        return disabledTestCount;
    }

    public AbstractJUnit38SpringContextTests() {
        this(null);
    }

    public AbstractJUnit38SpringContextTests(String name) {
        super(name);
        this.profileValueSource = ProfileValueUtils.retrieveProfileValueSource(((Object)((Object)this)).getClass());
    }

    public void runBare() throws Throwable {
        this.testContextManager.prepareTestInstance((Object)this);
        final Method testMethod = this.getTestMethod();
        if (!ProfileValueUtils.isTestEnabledInThisEnvironment(this.profileValueSource, testMethod)) {
            this.recordDisabled(testMethod);
            return;
        }
        this.runTestTimed(new TestExecutionCallback(){

            public void run() throws Throwable {
                AbstractJUnit38SpringContextTests.this.runManaged(testMethod);
            }
        }, testMethod);
    }

    private Method getTestMethod() {
        AbstractJUnit38SpringContextTests.assertNotNull((String)"TestCase.getName() cannot be null", (Object)this.getName());
        Method testMethod = null;
        try {
            testMethod = ((Object)((Object)this)).getClass().getMethod(this.getName(), null);
        }
        catch (NoSuchMethodException e) {
            AbstractJUnit38SpringContextTests.fail((String)("Method \"" + this.getName() + "\" not found"));
        }
        if (!Modifier.isPublic(testMethod.getModifiers())) {
            AbstractJUnit38SpringContextTests.fail((String)("Method \"" + this.getName() + "\" should be public"));
        }
        return testMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestTimed(TestExecutionCallback tec, Method testMethod) throws Throwable {
        Timed timed = testMethod.getAnnotation(Timed.class);
        if (timed == null) {
            this.runTest(tec, testMethod);
        } else {
            long startTime = System.currentTimeMillis();
            try {
                this.runTest(tec, testMethod);
            }
            finally {
                long elapsed = System.currentTimeMillis() - startTime;
                if (elapsed > timed.millis()) {
                    AbstractJUnit38SpringContextTests.fail((String)("Took " + elapsed + " ms; limit was " + timed.millis()));
                }
            }
        }
    }

    private void runTest(TestExecutionCallback tec, Method testMethod) throws Throwable {
        ExpectedException expectedExceptionAnnotation = testMethod.getAnnotation(ExpectedException.class);
        boolean exceptionIsExpected = expectedExceptionAnnotation != null && expectedExceptionAnnotation.value() != null;
        Class<? extends Throwable> expectedException = exceptionIsExpected ? expectedExceptionAnnotation.value() : null;
        Repeat repeat = testMethod.getAnnotation(Repeat.class);
        int runs = repeat != null && repeat.value() > 1 ? repeat.value() : 1;
        for (int i = 0; i < runs; ++i) {
            try {
                if (runs > 1 && this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Repetition " + (i + 1) + " of test " + testMethod.getName()));
                }
                tec.run();
                if (!exceptionIsExpected) continue;
                AbstractJUnit38SpringContextTests.fail((String)("Expected exception: " + expectedException.getName()));
                continue;
            }
            catch (Throwable t) {
                if (!exceptionIsExpected) {
                    throw t;
                }
                if (expectedException.isAssignableFrom(t.getClass())) continue;
                AssertionFailedError assertionError = new AssertionFailedError("Unexpected exception, expected<" + expectedException.getName() + "> but was<" + t.getClass().getName() + ">");
                assertionError.initCause(t);
                throw assertionError;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runManaged(Method testMethod) throws Throwable {
        Throwable exception;
        block20: {
            exception = null;
            try {
                this.testContextManager.beforeTestMethod((Object)this, testMethod);
            }
            catch (Throwable t) {
                if (t.getCause() instanceof AssertionError) {
                    t = t.getCause();
                }
                throw t;
            }
            this.setUp();
            try {
                super.runTest();
            }
            catch (Throwable running) {
                exception = running;
            }
            finally {
                block19: {
                    try {
                        this.tearDown();
                    }
                    catch (Throwable tearingDown) {
                        if (exception != null) break block19;
                        exception = tearingDown;
                    }
                }
            }
            try {
                this.testContextManager.afterTestMethod((Object)this, testMethod, exception);
            }
            catch (Throwable t) {
                if (exception != null) break block20;
                exception = t;
            }
        }
        if (exception != null) {
            if (exception.getCause() instanceof AssertionError) {
                exception = exception.getCause();
            }
            throw exception;
        }
    }

    public final void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected void recordDisabled(Method testMethod) {
        ++disabledTestCount;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("**** " + ((Object)((Object)this)).getClass().getName() + "." + this.getName() + "() is disabled in this environment: " + "Total disabled tests = " + AbstractJUnit38SpringContextTests.getDisabledTestCount()));
        }
    }

    private static interface TestExecutionCallback {
        public void run() throws Throwable;
    }
}

