/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.setup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.web.util.UrlPathHelper;

final class PatternMappingFilterProxy
implements Filter {
    private static final String EXTENSION_MAPPING_PATTERN = "*.";
    private static final String PATH_MAPPING_PATTERN = "/*";
    private static final UrlPathHelper urlPathHelper = new UrlPathHelper();
    private final Filter delegate;
    private final List<String> exactMatches = new ArrayList<String>();
    private final List<String> startsWithMatches = new ArrayList<String>();
    private final List<String> endsWithMatches = new ArrayList<String>();

    public PatternMappingFilterProxy(Filter delegate, String ... urlPatterns) {
        Assert.notNull((Object)delegate, (String)"A delegate Filter is required");
        this.delegate = delegate;
        for (String urlPattern : urlPatterns) {
            this.addUrlPattern(urlPattern);
        }
    }

    private void addUrlPattern(String urlPattern) {
        Assert.notNull((Object)urlPattern, (String)"Found null URL Pattern");
        if (urlPattern.startsWith(EXTENSION_MAPPING_PATTERN)) {
            this.endsWithMatches.add(urlPattern.substring(1, urlPattern.length()));
        } else if (urlPattern.equals(PATH_MAPPING_PATTERN)) {
            this.startsWithMatches.add("");
        } else if (urlPattern.endsWith(PATH_MAPPING_PATTERN)) {
            this.startsWithMatches.add(urlPattern.substring(0, urlPattern.length() - 1));
            this.exactMatches.add(urlPattern.substring(0, urlPattern.length() - 2));
        } else {
            if ("".equals(urlPattern)) {
                urlPattern = "/";
            }
            this.exactMatches.add(urlPattern);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String requestPath = urlPathHelper.getPathWithinApplication(httpRequest);
        if (this.matches(requestPath)) {
            this.delegate.doFilter(request, response, filterChain);
        } else {
            filterChain.doFilter(request, response);
        }
    }

    private boolean matches(String requestPath) {
        for (String pattern : this.exactMatches) {
            if (!pattern.equals(requestPath)) continue;
            return true;
        }
        if (!requestPath.startsWith("/")) {
            return false;
        }
        for (String pattern : this.endsWithMatches) {
            if (!requestPath.endsWith(pattern)) continue;
            return true;
        }
        for (String pattern : this.startsWithMatches) {
            if (!requestPath.startsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.delegate.init(filterConfig);
    }

    public void destroy() {
        this.delegate.destroy();
    }
}

