/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.setup;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockRequestDispatcher;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.web.server.setup.AbstractMockMvcBuilder;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextMockMvcBuilder
extends AbstractMockMvcBuilder<ContextMockMvcBuilder> {
    private final ConfigurableWebApplicationContext webAppContext;
    private String webResourceBasePath = "";
    private ResourceLoader webResourceLoader = new FileSystemResourceLoader();

    public ContextMockMvcBuilder(ConfigurableWebApplicationContext applicationContext) {
        this.webAppContext = applicationContext;
    }

    public ContextMockMvcBuilder configureWebAppRootDir(String warRootDir, boolean isClasspathRelative) {
        this.webResourceBasePath = warRootDir;
        this.webResourceLoader = isClasspathRelative ? new DefaultResourceLoader() : new FileSystemResourceLoader();
        return this;
    }

    public ContextMockMvcBuilder activateProfiles(String ... profiles) {
        this.webAppContext.getEnvironment().setActiveProfiles(profiles);
        return this;
    }

    public <T extends ConfigurableWebApplicationContext> ContextMockMvcBuilder applyInitializers(ApplicationContextInitializer<T> ... initializers) {
        for (ApplicationContextInitializer<T> initializer : initializers) {
            initializer.initialize((ConfigurableApplicationContext)this.webAppContext);
        }
        return this;
    }

    @Override
    protected WebApplicationContext initWebApplicationContext() {
        MockServletContext servletContext = new MockServletContext(this.webResourceBasePath, this.webResourceLoader){

            public RequestDispatcher getNamedDispatcher(String path) {
                return path.equals("default") ? new MockRequestDispatcher(path) : super.getNamedDispatcher(path);
            }
        };
        this.webAppContext.setServletContext((ServletContext)servletContext);
        this.webAppContext.refresh();
        return this.webAppContext;
    }

    public ContextMockMvcBuilder setParentContext(ApplicationContext parentContext) {
        this.webAppContext.setParent(parentContext);
        return this;
    }
}

