/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.server.result;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.springframework.test.web.AssertionErrors;
import org.springframework.test.web.server.MvcResult;
import org.springframework.test.web.server.ResultMatcher;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelResultMatchers {
    protected ModelResultMatchers() {
    }

    public <T> ResultMatcher attribute(final String name, final Matcher<T> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                ModelAndView mav = result.getModelAndView();
                AssertionErrors.assertTrue("No ModelAndView found", mav != null);
                MatcherAssert.assertThat((String)("Model attribute '" + name + "'"), mav.getModel().get(name), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher attribute(String name, Object value) {
        return this.attribute(name, Matchers.equalTo((Object)value));
    }

    public ResultMatcher attributeExists(final String ... names) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                AssertionErrors.assertTrue("No ModelAndView found", result.getModelAndView() != null);
                for (String name : names) {
                    ModelResultMatchers.this.attribute(name, Matchers.notNullValue()).match(result);
                }
            }
        };
    }

    public ResultMatcher attributeHasErrors(final String ... names) {
        return new ResultMatcher(){

            public void match(MvcResult mvcResult) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(mvcResult);
                for (String name : names) {
                    BindingResult result = ModelResultMatchers.this.getBindingResult(mav, name);
                    AssertionErrors.assertTrue("No errors for attribute: " + name, result.hasErrors());
                }
            }
        };
    }

    public ResultMatcher attributeHasNoErrors(final String ... names) {
        return new ResultMatcher(){

            public void match(MvcResult mvcResult) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(mvcResult);
                for (String name : names) {
                    BindingResult result = ModelResultMatchers.this.getBindingResult(mav, name);
                    AssertionErrors.assertTrue("No errors for attribute: " + name, !result.hasErrors());
                }
            }
        };
    }

    public ResultMatcher attributeHasFieldErrors(final String name, final String ... fieldNames) {
        return new ResultMatcher(){

            public void match(MvcResult mvcResult) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(mvcResult);
                BindingResult result = ModelResultMatchers.this.getBindingResult(mav, name);
                AssertionErrors.assertTrue("No errors for attribute: '" + name + "'", result.hasErrors());
                for (String fieldName : fieldNames) {
                    AssertionErrors.assertTrue("No errors for field: '" + fieldName + "' of attribute: " + name, result.hasFieldErrors(fieldName));
                }
            }
        };
    }

    public <T> ResultMatcher hasNoErrors() {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(result);
                for (Object value : mav.getModel().values()) {
                    if (!(value instanceof BindingResult)) continue;
                    AssertionErrors.assertTrue("Unexpected binding error(s): " + value, !((BindingResult)value).hasErrors());
                }
            }
        };
    }

    public <T> ResultMatcher size(final int size) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                ModelAndView mav = ModelResultMatchers.this.getModelAndView(result);
                int actual = 0;
                for (String key : mav.getModel().keySet()) {
                    if (key.startsWith(BindingResult.MODEL_KEY_PREFIX)) continue;
                    ++actual;
                }
                AssertionErrors.assertEquals("Model size", size, actual);
            }
        };
    }

    private ModelAndView getModelAndView(MvcResult mvcResult) {
        ModelAndView mav = mvcResult.getModelAndView();
        AssertionErrors.assertTrue("No ModelAndView found", mav != null);
        return mav;
    }

    private BindingResult getBindingResult(ModelAndView mav, String name) {
        BindingResult result = (BindingResult)mav.getModel().get(BindingResult.MODEL_KEY_PREFIX + name);
        AssertionErrors.assertTrue("No BindingResult for attribute: " + name, result != null);
        return result;
    }
}

