/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.web.AssertionErrors;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.match.ContentRequestMatchers;
import org.springframework.test.web.client.match.JsonPathRequestMatchers;
import org.springframework.test.web.client.match.XpathRequestMatchers;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestMatchers {
    private RequestMatchers() {
    }

    public static RequestMatcher anything() {
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError {
            }
        };
    }

    public static RequestMatcher requestTo(final Matcher<String> matcher) {
        Assert.notNull(matcher, (String)"'matcher' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                MatcherAssert.assertThat((String)"Request URI", (Object)request.getURI().toString(), (Matcher)matcher);
            }
        };
    }

    public static RequestMatcher requestTo(String uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        return RequestMatchers.requestTo((Matcher<String>)Matchers.equalTo((Object)uri));
    }

    public static RequestMatcher method(final HttpMethod method) {
        Assert.notNull((Object)method, (String)"'method' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError {
                AssertionErrors.assertEquals("Unexpected HttpMethod", method, request.getMethod());
            }
        };
    }

    public static RequestMatcher requestTo(final URI uri) {
        Assert.notNull((Object)uri, (String)"'uri' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                AssertionErrors.assertEquals("Unexpected request", uri, request.getURI());
            }
        };
    }

    public static RequestMatcher header(final String name, final Matcher<? super String> ... matchers) {
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) {
                HttpHeaders headers = request.getHeaders();
                List values = headers.get((Object)name);
                AssertionErrors.assertTrue("Expected header <" + name + ">", values != null);
                AssertionErrors.assertTrue("Expected header <" + name + "> to have at least <" + matchers.length + "> values but it has only <" + values.size() + ">", matchers.length <= values.size());
                for (int i = 0; i < matchers.length; ++i) {
                    MatcherAssert.assertThat((String)"Request header", headers.get((Object)name).get(i), (Matcher)matchers[i]);
                }
            }
        };
    }

    public static RequestMatcher header(String name, String ... values) {
        IsEqual[] matchers = new IsEqual[values.length];
        for (int i = 0; i < values.length; ++i) {
            matchers[i] = Matchers.equalTo((Object)values[i]);
        }
        return RequestMatchers.header(name, matchers);
    }

    public static ContentRequestMatchers content() {
        return new ContentRequestMatchers();
    }

    public static JsonPathRequestMatchers jsonPath(String expression, Object ... args) {
        return new JsonPathRequestMatchers(expression, args);
    }

    public static <T> RequestMatcher jsonPath(String expression, Matcher<T> matcher) {
        return new JsonPathRequestMatchers(expression, new Object[0]).value(matcher);
    }

    public static XpathRequestMatchers xpath(String expression, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, null, args);
    }

    public static XpathRequestMatchers xpath(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, namespaces, args);
    }

    public static RequestMatcher headerContains(final String header, final String substring) {
        Assert.notNull((Object)header, (String)"'header' must not be null");
        Assert.notNull((Object)substring, (String)"'substring' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError {
                List actualHeaders = request.getHeaders().get((Object)header);
                AssertionErrors.assertTrue("Expected header <" + header + "> in request", actualHeaders != null);
                boolean foundMatch = false;
                for (String headerValue : actualHeaders) {
                    if (!headerValue.contains(substring)) continue;
                    foundMatch = true;
                    break;
                }
                AssertionErrors.assertTrue("Expected value containing <" + substring + "> in header <" + header + ">", foundMatch);
            }
        };
    }

    public static RequestMatcher body(final String body) {
        Assert.notNull((Object)body, (String)"'body' must not be null");
        return new RequestMatcher(){

            public void match(ClientHttpRequest request) throws AssertionError, IOException {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request;
                AssertionErrors.assertEquals("Unexpected body content", body, mockRequest.getBodyAsString());
            }
        };
    }
}

