/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.connection.init;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.r2dbc.connection.ConnectionFactoryUtils;
import org.springframework.r2dbc.connection.init.ScriptException;
import org.springframework.r2dbc.connection.init.UncategorizedScriptException;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface DatabasePopulator {
    public Mono<Void> populate(Connection var1) throws ScriptException;

    default public Mono<Void> populate(ConnectionFactory connectionFactory) throws DataAccessException {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        return Mono.usingWhen(ConnectionFactoryUtils.getConnection(connectionFactory), this::populate, connection -> ConnectionFactoryUtils.releaseConnection(connection, connectionFactory), (connection, err) -> ConnectionFactoryUtils.releaseConnection(connection, connectionFactory), connection -> ConnectionFactoryUtils.releaseConnection(connection, connectionFactory)).onErrorMap(ex -> !(ex instanceof ScriptException), ex -> new UncategorizedScriptException("Failed to execute database script", (Throwable)ex));
    }
}

