/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.orm.jpa.hibernate.HibernateExceptionTranslator;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.ResourceTransactionDefinition;

public class HibernateJpaDialect
extends DefaultJpaDialect {
    private final HibernateExceptionTranslator exceptionTranslator = new HibernateExceptionTranslator();
    boolean prepareConnection = true;

    public void setPrepareConnection(boolean prepareConnection) {
        this.prepareConnection = prepareConnection;
    }

    public void setJdbcExceptionTranslator(@Nullable SQLExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator.setJdbcExceptionTranslator(exceptionTranslator);
    }

    @Override
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        ResourceTransactionDefinition rtd;
        SessionImplementor session = (SessionImplementor)entityManager.unwrap(SessionImplementor.class);
        if (definition.getTimeout() != -1) {
            session.getTransaction().setTimeout(definition.getTimeout());
        }
        boolean isolationLevelNeeded = definition.getIsolationLevel() != -1;
        Integer previousIsolationLevel = null;
        Connection preparedCon = null;
        if (isolationLevelNeeded || definition.isReadOnly()) {
            if (this.prepareConnection && ConnectionReleaseMode.ON_CLOSE.equals((Object)session.getJdbcCoordinator().getLogicalConnection().getConnectionHandlingMode().getReleaseMode())) {
                preparedCon = session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
                previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction((Connection)preparedCon, (TransactionDefinition)definition);
            } else if (isolationLevelNeeded) {
                throw new InvalidIsolationLevelException("HibernateJpaDialect is not allowed to support custom isolation levels: make sure that its 'prepareConnection' flag is on (the default) and that the Hibernate connection release mode is set to ON_CLOSE.");
            }
        }
        entityManager.getTransaction().begin();
        FlushMode previousFlushMode = this.prepareFlushMode((Session)session, definition.isReadOnly());
        if (definition instanceof ResourceTransactionDefinition && (rtd = (ResourceTransactionDefinition)definition).isLocalResource()) {
            previousFlushMode = null;
            if (definition.isReadOnly()) {
                session.setDefaultReadOnly(true);
            }
        }
        return new SessionTransactionData(session, previousFlushMode, preparedCon != null, previousIsolationLevel, definition.isReadOnly());
    }

    @Override
    public Object prepareTransaction(EntityManager entityManager, boolean readOnly, @Nullable String name) throws PersistenceException {
        SessionImplementor session = (SessionImplementor)entityManager.unwrap(SessionImplementor.class);
        FlushMode previousFlushMode = this.prepareFlushMode((Session)session, readOnly);
        return new SessionTransactionData(session, previousFlushMode, false, null, readOnly);
    }

    protected @Nullable FlushMode prepareFlushMode(Session session, boolean readOnly) throws PersistenceException {
        FlushMode flushMode = session.getHibernateFlushMode();
        if (readOnly) {
            if (!flushMode.equals((Object)FlushMode.MANUAL)) {
                session.setHibernateFlushMode(FlushMode.MANUAL);
                return flushMode;
            }
        } else if (flushMode.lessThan(FlushMode.COMMIT)) {
            session.setHibernateFlushMode(FlushMode.AUTO);
            return flushMode;
        }
        return null;
    }

    @Override
    public void cleanupTransaction(@Nullable Object transactionData) {
        if (transactionData instanceof SessionTransactionData) {
            SessionTransactionData sessionTransactionData = (SessionTransactionData)transactionData;
            sessionTransactionData.resetSessionState();
        }
    }

    @Override
    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        return new HibernateConnectionHandle((SessionImplementor)entityManager.unwrap(SessionImplementor.class));
    }

    @Override
    public @Nullable DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }

    private static class SessionTransactionData {
        private final SessionImplementor session;
        private final @Nullable FlushMode previousFlushMode;
        private final boolean needsConnectionReset;
        private final @Nullable Integer previousIsolationLevel;
        private final boolean readOnly;

        public SessionTransactionData(SessionImplementor session, @Nullable FlushMode previousFlushMode, boolean connectionPrepared, @Nullable Integer previousIsolationLevel, boolean readOnly) {
            this.session = session;
            this.previousFlushMode = previousFlushMode;
            this.needsConnectionReset = connectionPrepared;
            this.previousIsolationLevel = previousIsolationLevel;
            this.readOnly = readOnly;
        }

        public void resetSessionState() {
            if (this.previousFlushMode != null) {
                this.session.setHibernateFlushMode(this.previousFlushMode);
            }
            if (this.needsConnectionReset && this.session.getJdbcCoordinator().getLogicalConnection().isPhysicallyConnected()) {
                Connection con = this.session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
                DataSourceUtils.resetConnectionAfterTransaction((Connection)con, (Integer)this.previousIsolationLevel, (boolean)this.readOnly);
            }
        }
    }

    private static class HibernateConnectionHandle
    implements ConnectionHandle {
        private final SessionImplementor session;

        public HibernateConnectionHandle(SessionImplementor session) {
            this.session = session;
        }

        public Connection getConnection() {
            return this.session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
        }
    }
}

