/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.jspecify.annotations.Nullable;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;

public class EclipseLinkJpaDialect
extends DefaultJpaDialect {
    private boolean lazyDatabaseTransaction = false;
    private final Lock transactionIsolationLock = new ReentrantLock();

    public void setLazyDatabaseTransaction(boolean lazyDatabaseTransaction) {
        this.lazyDatabaseTransaction = lazyDatabaseTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public @Nullable Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        int currentIsolationLevel;
        if (definition.getTimeout() != -1) {
            entityManager.getTransaction().setTimeout(Integer.valueOf(definition.getTimeout()));
        }
        if ((currentIsolationLevel = definition.getIsolationLevel()) != -1) {
            UnitOfWork uow = (UnitOfWork)entityManager.unwrap(UnitOfWork.class);
            DatabaseLogin databaseLogin = uow.getLogin();
            this.transactionIsolationLock.lock();
            try {
                int originalIsolationLevel = databaseLogin.getTransactionIsolation();
                if (currentIsolationLevel != originalIsolationLevel) {
                    databaseLogin.setTransactionIsolation(currentIsolationLevel);
                }
                entityManager.getTransaction().begin();
                uow.beginEarlyTransaction();
                entityManager.unwrap(Connection.class);
                if (currentIsolationLevel == originalIsolationLevel) return null;
                databaseLogin.setTransactionIsolation(originalIsolationLevel);
                return null;
            }
            finally {
                this.transactionIsolationLock.unlock();
            }
        } else if (!definition.isReadOnly() && !this.lazyDatabaseTransaction) {
            UnitOfWork uow = (UnitOfWork)entityManager.unwrap(UnitOfWork.class);
            this.transactionIsolationLock.lock();
            try {
                entityManager.getTransaction().begin();
                uow.beginEarlyTransaction();
                entityManager.unwrap(Connection.class);
                return null;
            }
            finally {
                this.transactionIsolationLock.unlock();
            }
        } else {
            entityManager.getTransaction().begin();
        }
        return null;
    }

    @Override
    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        return new EclipseLinkConnectionHandle(entityManager);
    }

    private static class EclipseLinkConnectionHandle
    implements ConnectionHandle {
        private final EntityManager entityManager;
        private @Nullable Connection connection;

        public EclipseLinkConnectionHandle(EntityManager entityManager) {
            this.entityManager = entityManager;
        }

        public Connection getConnection() {
            if (this.connection == null) {
                this.connection = (Connection)this.entityManager.unwrap(Connection.class);
            }
            return this.connection;
        }
    }
}

