/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.PersistenceProvider;
import javax.sql.DataSource;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;

public class LocalEntityManagerFactoryBean
extends AbstractEntityManagerFactoryBean {
    private static final String DATASOURCE_PROPERTY = "jakarta.persistence.dataSource";
    private static final String NON_JTA_DATASOURCE_PROPERTY = "jakarta.persistence.nonJtaDataSource";

    public void setDataSource(@Nullable DataSource dataSource) {
        if (dataSource != null) {
            this.getJpaPropertyMap().put(DATASOURCE_PROPERTY, dataSource);
            this.getJpaPropertyMap().put(NON_JTA_DATASOURCE_PROPERTY, dataSource);
        } else {
            this.getJpaPropertyMap().remove(DATASOURCE_PROPERTY);
            this.getJpaPropertyMap().remove(NON_JTA_DATASOURCE_PROPERTY);
        }
    }

    @Override
    @Nullable
    public DataSource getDataSource() {
        return (DataSource)this.getJpaPropertyMap().get(DATASOURCE_PROPERTY);
    }

    @Override
    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        PersistenceProvider provider;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Building JPA EntityManagerFactory for persistence unit '" + this.getPersistenceUnitName() + "'"));
        }
        if ((provider = this.getPersistenceProvider()) != null) {
            EntityManagerFactory emf = provider.createEntityManagerFactory(this.getPersistenceUnitName(), this.getJpaPropertyMap());
            if (emf == null) {
                throw new PersistenceException("PersistenceProvider [" + String.valueOf(provider) + "] could not find persistence unit for name '" + this.getPersistenceUnitName() + "'");
            }
            return emf;
        }
        return Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), this.getJpaPropertyMap());
    }
}

