/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.orm.jpa.persistenceunit.SpringPersistenceUnitInfo;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.util.xml.SimpleSaxErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistenceUnitReader {
    private static final String PERSISTENCE_VERSION = "version";
    private static final String PERSISTENCE_UNIT = "persistence-unit";
    private static final String UNIT_NAME = "name";
    private static final String MAPPING_FILE_NAME = "mapping-file";
    private static final String JAR_FILE_URL = "jar-file";
    private static final String MANAGED_CLASS_NAME = "class";
    private static final String PROPERTIES = "properties";
    private static final String PROVIDER = "provider";
    private static final String TRANSACTION_TYPE = "transaction-type";
    private static final String JTA_DATA_SOURCE = "jta-data-source";
    private static final String NON_JTA_DATA_SOURCE = "non-jta-data-source";
    private static final String EXCLUDE_UNLISTED_CLASSES = "exclude-unlisted-classes";
    private static final String SHARED_CACHE_MODE = "shared-cache-mode";
    private static final String VALIDATION_MODE = "validation-mode";
    private static final String META_INF = "META-INF";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ResourcePatternResolver resourcePatternResolver;
    private final DataSourceLookup dataSourceLookup;

    public PersistenceUnitReader(ResourcePatternResolver resourcePatternResolver, DataSourceLookup dataSourceLookup) {
        Assert.notNull((Object)resourcePatternResolver, (String)"ResourceLoader must not be null");
        Assert.notNull((Object)dataSourceLookup, (String)"DataSourceLookup must not be null");
        this.resourcePatternResolver = resourcePatternResolver;
        this.dataSourceLookup = dataSourceLookup;
    }

    public SpringPersistenceUnitInfo[] readPersistenceUnitInfos(String persistenceXmlLocation) {
        return this.readPersistenceUnitInfos(new String[]{persistenceXmlLocation});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpringPersistenceUnitInfo[] readPersistenceUnitInfos(String[] persistenceXmlLocations) {
        SimpleSaxErrorHandler handler = new SimpleSaxErrorHandler(this.logger);
        LinkedList<SpringPersistenceUnitInfo> infos = new LinkedList<SpringPersistenceUnitInfo>();
        String resourceLocation = null;
        try {
            for (String location : persistenceXmlLocations) {
                Resource[] resources;
                for (Resource resource : resources = this.resourcePatternResolver.getResources(location)) {
                    resourceLocation = resource.toString();
                    InputStream stream = resource.getInputStream();
                    try {
                        Document document = this.buildDocument((ErrorHandler)handler, stream);
                        this.parseDocument(resource, document, infos);
                    }
                    finally {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot parse persistence unit from " + resourceLocation, ex);
        }
        catch (SAXException ex) {
            throw new IllegalArgumentException("Invalid XML in persistence unit from " + resourceLocation, ex);
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalArgumentException("Internal error parsing persistence unit from " + resourceLocation);
        }
        return infos.toArray(new SpringPersistenceUnitInfo[infos.size()]);
    }

    protected Document buildDocument(ErrorHandler handler, InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder parser = dbf.newDocumentBuilder();
        parser.setErrorHandler(handler);
        return parser.parse(stream);
    }

    protected List<SpringPersistenceUnitInfo> parseDocument(Resource resource, Document document, List<SpringPersistenceUnitInfo> infos) throws IOException {
        Element persistence = document.getDocumentElement();
        String version = persistence.getAttribute(PERSISTENCE_VERSION);
        URL unitRootURL = this.determinePersistenceUnitRootUrl(resource);
        List units = DomUtils.getChildElementsByTagName((Element)persistence, (String)PERSISTENCE_UNIT);
        for (Element unit : units) {
            SpringPersistenceUnitInfo info = this.parsePersistenceUnitInfo(unit, version);
            info.setPersistenceUnitRootUrl(unitRootURL);
            infos.add(info);
        }
        return infos;
    }

    protected URL determinePersistenceUnitRootUrl(Resource resource) throws IOException {
        URL originalURL = resource.getURL();
        String urlToString = originalURL.toExternalForm();
        if (ResourceUtils.isJarURL((URL)originalURL)) {
            return ResourceUtils.extractJarFileURL((URL)originalURL);
        }
        if (!urlToString.contains(META_INF)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)(resource.getFilename() + " should be located inside META-INF directory; cannot determine persistence unit root URL for " + resource));
            }
            return null;
        }
        if (urlToString.lastIndexOf(META_INF) == urlToString.lastIndexOf(47) - (1 + META_INF.length())) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)(resource.getFilename() + " is not located in the root of META-INF directory; cannot determine persistence unit root URL for " + resource));
            }
            return null;
        }
        String persistenceUnitRoot = urlToString.substring(0, urlToString.lastIndexOf(META_INF));
        return new URL(persistenceUnitRoot);
    }

    protected SpringPersistenceUnitInfo parsePersistenceUnitInfo(Element persistenceUnit, String version) throws IOException {
        String validationMode;
        String cacheMode;
        Element excludeUnlistedClasses;
        String provider;
        String nonJtaDataSource;
        String jtaDataSource;
        SpringPersistenceUnitInfo unitInfo = new SpringPersistenceUnitInfo();
        unitInfo.setPersistenceXMLSchemaVersion(version);
        unitInfo.setPersistenceUnitName(persistenceUnit.getAttribute(UNIT_NAME).trim());
        String txType = persistenceUnit.getAttribute(TRANSACTION_TYPE).trim();
        if (StringUtils.hasText((String)txType)) {
            unitInfo.setTransactionType(PersistenceUnitTransactionType.valueOf((String)txType));
        }
        if (StringUtils.hasText((String)(jtaDataSource = DomUtils.getChildElementValueByTagName((Element)persistenceUnit, (String)JTA_DATA_SOURCE)))) {
            unitInfo.setJtaDataSource(this.dataSourceLookup.getDataSource(jtaDataSource.trim()));
        }
        if (StringUtils.hasText((String)(nonJtaDataSource = DomUtils.getChildElementValueByTagName((Element)persistenceUnit, (String)NON_JTA_DATA_SOURCE)))) {
            unitInfo.setNonJtaDataSource(this.dataSourceLookup.getDataSource(nonJtaDataSource.trim()));
        }
        if (StringUtils.hasText((String)(provider = DomUtils.getChildElementValueByTagName((Element)persistenceUnit, (String)PROVIDER)))) {
            unitInfo.setPersistenceProviderClassName(provider.trim());
        }
        if ((excludeUnlistedClasses = DomUtils.getChildElementByTagName((Element)persistenceUnit, (String)EXCLUDE_UNLISTED_CLASSES)) != null) {
            unitInfo.setExcludeUnlistedClasses(true);
        }
        if (StringUtils.hasText((String)(cacheMode = DomUtils.getChildElementValueByTagName((Element)persistenceUnit, (String)SHARED_CACHE_MODE)))) {
            unitInfo.setSharedCacheModeName(cacheMode);
        }
        if (StringUtils.hasText((String)(validationMode = DomUtils.getChildElementValueByTagName((Element)persistenceUnit, (String)VALIDATION_MODE)))) {
            unitInfo.setValidationModeName(validationMode);
        }
        this.parseMappingFiles(persistenceUnit, unitInfo);
        this.parseJarFiles(persistenceUnit, unitInfo);
        this.parseClass(persistenceUnit, unitInfo);
        this.parseProperty(persistenceUnit, unitInfo);
        return unitInfo;
    }

    protected void parseProperty(Element persistenceUnit, SpringPersistenceUnitInfo unitInfo) {
        Element propRoot = DomUtils.getChildElementByTagName((Element)persistenceUnit, (String)PROPERTIES);
        if (propRoot == null) {
            return;
        }
        List properties = DomUtils.getChildElementsByTagName((Element)propRoot, (String)"property");
        for (Element property : properties) {
            String name = property.getAttribute(UNIT_NAME);
            String value = property.getAttribute("value");
            unitInfo.addProperty(name, value);
        }
    }

    protected void parseClass(Element persistenceUnit, SpringPersistenceUnitInfo unitInfo) {
        List classes = DomUtils.getChildElementsByTagName((Element)persistenceUnit, (String)MANAGED_CLASS_NAME);
        for (Element element : classes) {
            String value = DomUtils.getTextValue((Element)element).trim();
            if (!StringUtils.hasText((String)value)) continue;
            unitInfo.addManagedClassName(value);
        }
    }

    protected void parseJarFiles(Element persistenceUnit, SpringPersistenceUnitInfo unitInfo) throws IOException {
        List jars = DomUtils.getChildElementsByTagName((Element)persistenceUnit, (String)JAR_FILE_URL);
        for (Element element : jars) {
            Resource[] resources;
            String value = DomUtils.getTextValue((Element)element).trim();
            if (!StringUtils.hasText((String)value)) continue;
            for (Resource resource : resources = this.resourcePatternResolver.getResources(value)) {
                unitInfo.addJarFileUrl(resource.getURL());
            }
        }
    }

    protected void parseMappingFiles(Element persistenceUnit, SpringPersistenceUnitInfo unitInfo) {
        List files = DomUtils.getChildElementsByTagName((Element)persistenceUnit, (String)MAPPING_FILE_NAME);
        for (Element element : files) {
            String value = DomUtils.getTextValue((Element)element).trim();
            if (!StringUtils.hasText((String)value)) continue;
            unitInfo.addMappingFileName(value);
        }
    }
}

