/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.support;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateAccessor;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.AbstractDelegatingCallable;
import org.springframework.web.context.request.async.AsyncWebRequestInterceptor;

public class OpenSessionInViewInterceptor
extends HibernateAccessor
implements AsyncWebRequestInterceptor {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";
    private boolean singleSession = true;

    public OpenSessionInViewInterceptor() {
        this.setFlushMode(0);
    }

    public void setSingleSession(boolean singleSession) {
        this.singleSession = singleSession;
    }

    protected boolean isSingleSession() {
        return this.singleSession;
    }

    public void preHandle(WebRequest request) throws DataAccessException {
        if (this.isSingleSession() && TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory()) || SessionFactoryUtils.isDeferredCloseActive(this.getSessionFactory())) {
            String participateAttributeName = this.getParticipateAttributeName();
            Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), (Object)newCount, 0);
        } else if (this.isSingleSession()) {
            this.logger.debug((Object)"Opening single Hibernate Session in OpenSessionInViewInterceptor");
            Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
            this.applyFlushMode(session, false);
            SessionHolder sessionHolder = new SessionHolder(session);
            TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)sessionHolder));
        } else {
            SessionFactoryUtils.initDeferredClose(this.getSessionFactory());
        }
    }

    public AbstractDelegatingCallable getAsyncCallable(WebRequest request) {
        String attributeName = this.getParticipateAttributeName();
        if (request.getAttribute(attributeName, 0) != null || !this.isSingleSession()) {
            return null;
        }
        final SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory()));
        return new AbstractDelegatingCallable(){

            public Object call() throws Exception {
                TransactionSynchronizationManager.bindResource((Object)OpenSessionInViewInterceptor.this.getSessionFactory(), (Object)((Object)sessionHolder));
                this.getNextCallable().call();
                return null;
            }
        };
    }

    public void postHandleAsyncStarted(WebRequest request) {
        String attributeName = this.getParticipateAttributeName();
        if (request.getAttribute(attributeName, 0) == null) {
            if (this.isSingleSession()) {
                TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
            } else {
                throw new IllegalStateException("Deferred close is not supported with async requests.");
            }
        }
    }

    public void postHandle(WebRequest request, ModelMap model) throws DataAccessException {
        if (this.isSingleSession()) {
            SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory()));
            this.logger.debug((Object)"Flushing single Hibernate Session in OpenSessionInViewInterceptor");
            try {
                this.flushIfNecessary(sessionHolder.getSession(), false);
            }
            catch (HibernateException ex) {
                throw this.convertHibernateAccessException(ex);
            }
        }
    }

    public void afterCompletion(WebRequest request, Exception ex) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
        if (count != null) {
            if (count > 1) {
                request.setAttribute(participateAttributeName, (Object)(count - 1), 0);
            } else {
                request.removeAttribute(participateAttributeName, 0);
            }
        } else if (this.isSingleSession()) {
            SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory()));
            this.logger.debug((Object)"Closing single Hibernate Session in OpenSessionInViewInterceptor");
            SessionFactoryUtils.closeSession(sessionHolder.getSession());
        } else {
            SessionFactoryUtils.processDeferredClose(this.getSessionFactory());
        }
    }

    protected String getParticipateAttributeName() {
        return this.getSessionFactory().toString() + PARTICIPATE_SUFFIX;
    }
}

