/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate4;

import java.sql.Connection;
import javax.sql.DataSource;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.classic.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    private SessionFactory sessionFactory;
    private DataSource dataSource;
    private boolean autodetectDataSource = true;
    private boolean prepareConnection = true;
    private boolean hibernateManagedSession = false;

    public HibernateTransactionManager() {
    }

    public HibernateTransactionManager(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.afterPropertiesSet();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setAutodetectDataSource(boolean autodetectDataSource) {
        this.autodetectDataSource = autodetectDataSource;
    }

    public void setPrepareConnection(boolean prepareConnection) {
        this.prepareConnection = prepareConnection;
    }

    public void setHibernateManagedSession(boolean hibernateManagedSession) {
        this.hibernateManagedSession = hibernateManagedSession;
    }

    public void afterPropertiesSet() {
        DataSource sfds;
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("Property 'sessionFactory' is required");
        }
        if (this.autodetectDataSource && this.getDataSource() == null && (sfds = SessionFactoryUtils.getDataSource(this.getSessionFactory())) != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using DataSource [" + sfds + "] of Hibernate SessionFactory for HibernateTransactionManager"));
            }
            this.setDataSource(sfds);
        }
    }

    public Object getResourceFactory() {
        return this.getSessionFactory();
    }

    protected Object doGetTransaction() {
        HibernateTransactionObject txObject = new HibernateTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory()));
        if (sessionHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found thread-bound Session [" + sessionHolder.getSession() + "] for Hibernate transaction"));
            }
            txObject.setSessionHolder(sessionHolder);
        } else if (this.hibernateManagedSession) {
            try {
                Session session = this.getSessionFactory().getCurrentSession();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found Hibernate-managed Session [" + session + "] for Spring-managed transaction"));
                }
                txObject.setExistingSession((org.hibernate.Session)session);
            }
            catch (HibernateException ex) {
                throw new DataAccessResourceFailureException("Could not obtain Hibernate-managed Session for Spring-managed transaction", (Throwable)ex);
            }
        }
        if (this.getDataSource() != null) {
            ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.getDataSource());
            txObject.setConnectionHolder(conHolder);
        }
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)transaction);
        return txObject.hasSpringManagedTransaction() || this.hibernateManagedSession && txObject.hasHibernateManagedTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)transaction);
        if (txObject.hasConnectionHolder() && !txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found! HibernateTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single HibernateTransactionManager for all transactions on a single DataSource, no matter whether Hibernate or JDBC access.");
        }
        org.hibernate.Session session = null;
        try {
            Transaction hibTx;
            int timeout;
            if (txObject.getSessionHolder() == null || txObject.getSessionHolder().isSynchronizedWithTransaction()) {
                org.hibernate.Session newSession = SessionFactoryUtils.openSession(this.getSessionFactory());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Opened new Session [" + newSession + "] for Hibernate transaction"));
                }
                txObject.setSession(newSession);
            }
            session = txObject.getSessionHolder().getSession();
            if (this.prepareConnection && this.isSameConnectionForEntireSession(session)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Preparing JDBC Connection of Hibernate Session [" + session + "]"));
                }
                Connection con = ((SessionImplementor)session).connection();
                Integer previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction((Connection)con, (TransactionDefinition)definition);
                txObject.setPreviousIsolationLevel(previousIsolationLevel);
            } else {
                if (definition.getIsolationLevel() != -1) {
                    throw new InvalidIsolationLevelException("HibernateTransactionManager is not allowed to support custom isolation levels: make sure that its 'prepareConnection' flag is on (the default) and that the Hibernate connection release mode is set to 'on_close' (SpringTransactionFactory's default).");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Not preparing JDBC Connection of Hibernate Session [" + session + "]"));
                }
            }
            if (definition.isReadOnly() && txObject.isNewSession()) {
                session.setFlushMode(FlushMode.MANUAL);
            }
            if (!definition.isReadOnly() && !txObject.isNewSession()) {
                FlushMode flushMode = session.getFlushMode();
                if (FlushMode.isManualFlushMode((FlushMode)session.getFlushMode())) {
                    session.setFlushMode(FlushMode.AUTO);
                    txObject.getSessionHolder().setPreviousFlushMode(flushMode);
                }
            }
            if ((timeout = this.determineTimeout(definition)) != -1) {
                hibTx = session.getTransaction();
                hibTx.setTimeout(timeout);
                hibTx.begin();
            } else {
                hibTx = session.beginTransaction();
            }
            txObject.getSessionHolder().setTransaction(hibTx);
            if (this.getDataSource() != null) {
                Connection con = ((SessionImplementor)session).connection();
                ConnectionHolder conHolder = new ConnectionHolder(con);
                if (timeout != -1) {
                    conHolder.setTimeoutInSeconds(timeout);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Exposing Hibernate transaction as JDBC transaction [" + con + "]"));
                }
                TransactionSynchronizationManager.bindResource((Object)this.getDataSource(), (Object)conHolder);
                txObject.setConnectionHolder(conHolder);
            }
            if (txObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)txObject.getSessionHolder()));
            }
            txObject.getSessionHolder().setSynchronizedWithTransaction(true);
        }
        catch (Exception ex) {
            block26: {
                if (txObject.isNewSession()) {
                    try {
                        try {
                            if (session.getTransaction().isActive()) {
                                session.getTransaction().rollback();
                            }
                        }
                        catch (Throwable throwable) {
                            this.logger.debug((Object)"Could not rollback Session after failed transaction begin", (Throwable)ex);
                            SessionFactoryUtils.closeSession(session);
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        SessionFactoryUtils.closeSession(session);
                        throw throwable;
                    }
                    SessionFactoryUtils.closeSession(session);
                }
            }
            throw new CannotCreateTransactionException("Could not open Hibernate Session for transaction", (Throwable)ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)transaction);
        txObject.setSessionHolder(null);
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory()));
        txObject.setConnectionHolder(null);
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource((Object)this.getDataSource());
        }
        return new SuspendedResourcesHolder(sessionHolder, connectionHolder);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        if (TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        }
        TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)resourcesHolder.getSessionHolder()));
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.bindResource((Object)this.getDataSource(), (Object)resourcesHolder.getConnectionHolder());
        }
    }

    protected void doCommit(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing Hibernate transaction on Session [" + txObject.getSessionHolder().getSession() + "]"));
        }
        try {
            txObject.getSessionHolder().getTransaction().commit();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not commit Hibernate transaction", (Throwable)ex);
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back Hibernate transaction on Session [" + txObject.getSessionHolder().getSession() + "]"));
        }
        try {
            try {
                txObject.getSessionHolder().getTransaction().rollback();
            }
            catch (TransactionException ex) {
                throw new TransactionSystemException("Could not roll back Hibernate transaction", (Throwable)ex);
            }
            catch (HibernateException ex) {
                throw this.convertHibernateAccessException(ex);
            }
        }
        finally {
            if (!txObject.isNewSession() && !this.hibernateManagedSession) {
                txObject.getSessionHolder().getSession().clear();
            }
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)status.getTransaction());
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting Hibernate transaction on Session [" + txObject.getSessionHolder().getSession() + "] rollback-only"));
        }
        txObject.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)((Object)transaction);
        if (txObject.isNewSessionHolder()) {
            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        }
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.unbindResource((Object)this.getDataSource());
        }
        org.hibernate.Session session = txObject.getSessionHolder().getSession();
        if (this.prepareConnection && session.isConnected() && this.isSameConnectionForEntireSession(session)) {
            try {
                Connection con = ((SessionImplementor)session).connection();
                DataSourceUtils.resetConnectionAfterTransaction((Connection)con, (Integer)txObject.getPreviousIsolationLevel());
            }
            catch (HibernateException ex) {
                this.logger.debug((Object)"Could not access JDBC Connection of Hibernate Session", (Throwable)ex);
            }
        }
        if (txObject.isNewSession()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing Hibernate Session [" + session + "] after transaction"));
            }
            SessionFactoryUtils.closeSession(session);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not closing pre-bound Hibernate Session [" + session + "] after transaction"));
            }
            if (txObject.getSessionHolder().getPreviousFlushMode() != null) {
                session.setFlushMode(txObject.getSessionHolder().getPreviousFlushMode());
            }
            if (!this.hibernateManagedSession) {
                session.disconnect();
            }
        }
        txObject.getSessionHolder().clear();
    }

    protected boolean isSameConnectionForEntireSession(org.hibernate.Session session) {
        if (!(session instanceof TransactionContext)) {
            return true;
        }
        ConnectionReleaseMode releaseMode = ((TransactionContext)session).getConnectionReleaseMode();
        return ConnectionReleaseMode.ON_CLOSE.equals(releaseMode);
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }

    private class HibernateTransactionObject
    extends JdbcTransactionObjectSupport {
        private SessionHolder sessionHolder;
        private boolean newSessionHolder;
        private boolean newSession;

        private HibernateTransactionObject() {
        }

        public void setSession(org.hibernate.Session session) {
            this.sessionHolder = new SessionHolder(session);
            this.newSessionHolder = true;
            this.newSession = true;
        }

        public void setExistingSession(org.hibernate.Session session) {
            this.sessionHolder = new SessionHolder(session);
            this.newSessionHolder = true;
            this.newSession = false;
        }

        public void setSessionHolder(SessionHolder sessionHolder) {
            this.sessionHolder = sessionHolder;
            this.newSessionHolder = false;
            this.newSession = false;
        }

        public SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        public boolean isNewSessionHolder() {
            return this.newSessionHolder;
        }

        public boolean isNewSession() {
            return this.newSession;
        }

        public boolean hasSpringManagedTransaction() {
            return this.sessionHolder != null && this.sessionHolder.getTransaction() != null;
        }

        public boolean hasHibernateManagedTransaction() {
            return this.sessionHolder != null && this.sessionHolder.getSession().getTransaction().isActive();
        }

        public void setRollbackOnly() {
            this.sessionHolder.setRollbackOnly();
            if (this.hasConnectionHolder()) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        public boolean isRollbackOnly() {
            return this.sessionHolder.isRollbackOnly() || this.hasConnectionHolder() && this.getConnectionHolder().isRollbackOnly();
        }

        public void flush() {
            try {
                this.sessionHolder.getSession().flush();
            }
            catch (HibernateException ex) {
                throw HibernateTransactionManager.this.convertHibernateAccessException(ex);
            }
        }
    }

    private static class SuspendedResourcesHolder {
        private final SessionHolder sessionHolder;
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(SessionHolder sessionHolder, ConnectionHolder conHolder) {
            this.sessionHolder = sessionHolder;
            this.connectionHolder = conHolder;
        }

        private SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }
}

