/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.stomp.StompConversionException;
import org.springframework.messaging.simp.stomp.StompDecoder;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class BufferingStompDecoder
extends StompDecoder {
    private final int bufferSizeLimit;
    private final Queue<ByteBuffer> chunks = new LinkedBlockingQueue<ByteBuffer>();
    private volatile Integer expectedContentLength;

    public BufferingStompDecoder(int bufferSizeLimit) {
        Assert.isTrue((bufferSizeLimit > 0 ? 1 : 0) != 0, (String)"Buffer size must be greater than 0");
        this.bufferSizeLimit = bufferSizeLimit;
    }

    public int getBufferSizeLimit() {
        return this.bufferSizeLimit;
    }

    public int getBufferSize() {
        int size = 0;
        for (ByteBuffer buffer : this.chunks) {
            size += buffer.remaining();
        }
        return size;
    }

    public Integer getExpectedContentLength() {
        return this.expectedContentLength;
    }

    @Override
    public List<Message<byte[]>> decode(ByteBuffer newBuffer) {
        this.chunks.add(newBuffer);
        this.checkBufferLimits();
        if (this.getExpectedContentLength() != null && this.getBufferSize() < this.expectedContentLength) {
            return Collections.emptyList();
        }
        ByteBuffer bufferToDecode = this.assembleChunksAndReset();
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        List<Message<byte[]>> messages = this.decode(bufferToDecode, (MultiValueMap<String, String>)headers);
        if (bufferToDecode.hasRemaining()) {
            this.chunks.add(bufferToDecode);
            this.expectedContentLength = this.getContentLength((MultiValueMap<String, String>)headers);
        }
        return messages;
    }

    private void checkBufferLimits() {
        if (this.getExpectedContentLength() != null && this.getExpectedContentLength() > this.getBufferSizeLimit()) {
            throw new StompConversionException("The 'content-length' header " + this.getExpectedContentLength() + "  exceeds the configured message buffer size limit " + this.getBufferSizeLimit());
        }
        if (this.getBufferSize() > this.getBufferSizeLimit()) {
            throw new StompConversionException("The configured stomp frame buffer size limit of " + this.getBufferSizeLimit() + " bytes has been exceeded");
        }
    }

    private ByteBuffer assembleChunksAndReset() {
        ByteBuffer result;
        if (this.chunks.size() == 1) {
            result = this.chunks.remove();
        } else {
            result = ByteBuffer.allocate(this.getBufferSize());
            for (ByteBuffer partial : this.chunks) {
                result.put(partial);
            }
            result.flip();
        }
        this.chunks.clear();
        this.expectedContentLength = null;
        return result;
    }
}

