/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.core;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.InvalidDestinationException;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsMessageOperations;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.support.JmsAccessor;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.MessagingMessageConverter;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.core.AbstractMessagingTemplate;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.util.Assert;

public class JmsMessagingTemplate
extends AbstractMessagingTemplate<Destination>
implements JmsMessageOperations,
InitializingBean {
    private @Nullable JmsOperations jmsTemplate;
    private MessageConverter jmsMessageConverter;
    private boolean converterSet;
    private @Nullable String defaultDestinationName;

    public JmsMessagingTemplate() {
        this.jmsMessageConverter = new MessagingMessageConverter();
    }

    public JmsMessagingTemplate(ConnectionFactory connectionFactory) {
        this(new JmsTemplate(connectionFactory));
    }

    public JmsMessagingTemplate(JmsTemplate jmsTemplate) {
        Assert.notNull((Object)jmsTemplate, (String)"JmsTemplate must not be null");
        this.jmsTemplate = jmsTemplate;
        this.jmsMessageConverter = new MessagingMessageConverter(jmsTemplate.getMessageConverter());
    }

    public JmsMessagingTemplate(JmsOperations jmsTemplate) {
        MessagingMessageConverter messagingMessageConverter;
        Assert.notNull((Object)jmsTemplate, (String)"JmsTemplate must not be null");
        this.jmsTemplate = jmsTemplate;
        if (jmsTemplate instanceof JmsTemplate) {
            JmsTemplate template = (JmsTemplate)jmsTemplate;
            messagingMessageConverter = new MessagingMessageConverter(template.getMessageConverter());
        } else {
            messagingMessageConverter = new MessagingMessageConverter();
        }
        this.jmsMessageConverter = messagingMessageConverter;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        JmsOperations jmsOperations = this.jmsTemplate;
        if (jmsOperations instanceof JmsAccessor) {
            JmsAccessor accessor = (JmsAccessor)((Object)jmsOperations);
            JmsTemplate template = new JmsTemplate(accessor);
            template.setConnectionFactory(connectionFactory);
            this.jmsTemplate = template;
        } else {
            this.jmsTemplate = new JmsTemplate(connectionFactory);
        }
    }

    public @Nullable ConnectionFactory getConnectionFactory() {
        ConnectionFactory connectionFactory;
        JmsOperations jmsOperations = this.jmsTemplate;
        if (jmsOperations instanceof JmsTemplate) {
            JmsTemplate template = (JmsTemplate)jmsOperations;
            connectionFactory = template.getConnectionFactory();
        } else {
            connectionFactory = null;
        }
        return connectionFactory;
    }

    public void setJmsTemplate(@Nullable JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public @Nullable JmsTemplate getJmsTemplate() {
        JmsTemplate template;
        JmsOperations jmsOperations = this.jmsTemplate;
        return jmsOperations instanceof JmsTemplate ? (template = (JmsTemplate)jmsOperations) : null;
    }

    public void setJmsMessageConverter(MessageConverter jmsMessageConverter) {
        Assert.notNull((Object)jmsMessageConverter, (String)"MessageConverter must not be null");
        this.jmsMessageConverter = jmsMessageConverter;
        this.converterSet = true;
    }

    public MessageConverter getJmsMessageConverter() {
        return this.jmsMessageConverter;
    }

    public void setDefaultDestinationName(@Nullable String defaultDestinationName) {
        this.defaultDestinationName = defaultDestinationName;
    }

    public @Nullable String getDefaultDestinationName() {
        return this.defaultDestinationName;
    }

    public void afterPropertiesSet() {
        JmsOperations jmsOperations;
        Assert.notNull((Object)this.jmsTemplate, (String)"Property 'connectionFactory' or 'jmsTemplate' is required");
        if (!this.converterSet && (jmsOperations = this.jmsTemplate) instanceof JmsTemplate) {
            JmsTemplate template = (JmsTemplate)jmsOperations;
            ((MessagingMessageConverter)this.jmsMessageConverter).setPayloadConverter(template.getMessageConverter());
        }
    }

    JmsOperations obtainJmsTemplate() {
        Assert.state((this.jmsTemplate != null ? 1 : 0) != 0, (String)"No JmsTemplate set");
        return this.jmsTemplate;
    }

    public void send(org.springframework.messaging.Message<?> message) throws MessagingException {
        Destination defaultDestination = (Destination)this.getDefaultDestination();
        if (defaultDestination != null) {
            this.send(defaultDestination, message);
        } else {
            this.send(this.getRequiredDefaultDestinationName(), message);
        }
    }

    public void convertAndSend(Object payload, @Nullable Map<String, Object> headers, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        Destination defaultDestination = (Destination)this.getDefaultDestination();
        if (defaultDestination != null) {
            this.convertAndSend(defaultDestination, payload, headers, postProcessor);
        } else {
            this.convertAndSend(this.getRequiredDefaultDestinationName(), payload, headers, postProcessor);
        }
    }

    @Override
    public void send(String destinationName, org.springframework.messaging.Message<?> message) throws MessagingException {
        this.doSend(destinationName, message);
    }

    @Override
    public void convertAndSend(String destinationName, Object payload) throws MessagingException {
        this.convertAndSend(destinationName, payload, (Map<String, Object>)null);
    }

    @Override
    public void convertAndSend(String destinationName, Object payload, @Nullable Map<String, Object> headers) throws MessagingException {
        this.convertAndSend(destinationName, payload, headers, null);
    }

    @Override
    public void convertAndSend(String destinationName, Object payload, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        this.convertAndSend(destinationName, payload, null, postProcessor);
    }

    @Override
    public void convertAndSend(String destinationName, Object payload, @Nullable Map<String, Object> headers, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        org.springframework.messaging.Message message = this.doConvert(payload, headers, postProcessor);
        this.send(destinationName, message);
    }

    public @Nullable org.springframework.messaging.Message<?> receive() throws MessagingException {
        Destination defaultDestination = (Destination)this.getDefaultDestination();
        if (defaultDestination != null) {
            return this.receive(defaultDestination);
        }
        return this.receive(this.getRequiredDefaultDestinationName());
    }

    public <T> @Nullable T receiveAndConvert(Class<T> targetClass) throws MessagingException {
        Destination defaultDestination = (Destination)this.getDefaultDestination();
        if (defaultDestination != null) {
            return (T)this.receiveAndConvert(defaultDestination, targetClass);
        }
        return this.receiveAndConvert(this.getRequiredDefaultDestinationName(), targetClass);
    }

    @Override
    public @Nullable org.springframework.messaging.Message<?> receive(String destinationName) throws MessagingException {
        return this.doReceive(destinationName);
    }

    @Override
    public <T> @Nullable T receiveAndConvert(String destinationName, Class<T> targetClass) throws MessagingException {
        org.springframework.messaging.Message<?> message = this.doReceive(destinationName);
        if (message != null) {
            return (T)this.doConvert(message, targetClass);
        }
        return null;
    }

    @Override
    public @Nullable org.springframework.messaging.Message<?> receiveSelected(@Nullable String messageSelector) throws MessagingException {
        Destination defaultDestination = (Destination)this.getDefaultDestination();
        if (defaultDestination != null) {
            return this.receiveSelected(defaultDestination, messageSelector);
        }
        return this.receiveSelected(this.getRequiredDefaultDestinationName(), messageSelector);
    }

    @Override
    public @Nullable org.springframework.messaging.Message<?> receiveSelected(Destination destination, @Nullable String messageSelector) throws MessagingException {
        return this.doReceiveSelected(destination, messageSelector);
    }

    @Override
    public @Nullable org.springframework.messaging.Message<?> receiveSelected(String destinationName, @Nullable String messageSelector) throws MessagingException {
        return this.doReceiveSelected(destinationName, messageSelector);
    }

    @Override
    public <T> @Nullable T receiveSelectedAndConvert(@Nullable String messageSelector, Class<T> targetClass) throws MessagingException {
        Destination defaultDestination = (Destination)this.getDefaultDestination();
        if (defaultDestination != null) {
            return this.receiveSelectedAndConvert(defaultDestination, messageSelector, targetClass);
        }
        return this.receiveSelectedAndConvert(this.getRequiredDefaultDestinationName(), messageSelector, targetClass);
    }

    @Override
    public <T> @Nullable T receiveSelectedAndConvert(Destination destination, @Nullable String messageSelector, Class<T> targetClass) throws MessagingException {
        org.springframework.messaging.Message<?> message = this.doReceiveSelected(destination, messageSelector);
        if (message != null) {
            return (T)this.doConvert(message, targetClass);
        }
        return null;
    }

    @Override
    public <T> @Nullable T receiveSelectedAndConvert(String destinationName, @Nullable String messageSelector, Class<T> targetClass) throws MessagingException {
        org.springframework.messaging.Message<?> message = this.doReceiveSelected(destinationName, messageSelector);
        if (message != null) {
            return (T)this.doConvert(message, targetClass);
        }
        return null;
    }

    public @Nullable org.springframework.messaging.Message<?> sendAndReceive(org.springframework.messaging.Message<?> requestMessage) throws MessagingException {
        Destination defaultDestination = (Destination)this.getDefaultDestination();
        if (defaultDestination != null) {
            return this.sendAndReceive(defaultDestination, requestMessage);
        }
        return this.sendAndReceive(this.getRequiredDefaultDestinationName(), requestMessage);
    }

    @Override
    public @Nullable org.springframework.messaging.Message<?> sendAndReceive(String destinationName, org.springframework.messaging.Message<?> requestMessage) throws MessagingException {
        return this.doSendAndReceive(destinationName, requestMessage);
    }

    @Override
    public <T> @Nullable T convertSendAndReceive(String destinationName, Object request, Class<T> targetClass) throws MessagingException {
        return this.convertSendAndReceive(destinationName, request, null, targetClass);
    }

    public <T> @Nullable T convertSendAndReceive(Object request, Class<T> targetClass) throws MessagingException {
        return this.convertSendAndReceive(request, targetClass, null);
    }

    @Override
    public <T> @Nullable T convertSendAndReceive(String destinationName, Object request, @Nullable Map<String, Object> headers, Class<T> targetClass) throws MessagingException {
        return this.convertSendAndReceive(destinationName, request, headers, targetClass, null);
    }

    public <T> @Nullable T convertSendAndReceive(Object request, Class<T> targetClass, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        Destination defaultDestination = (Destination)this.getDefaultDestination();
        if (defaultDestination != null) {
            return (T)this.convertSendAndReceive(defaultDestination, request, targetClass, postProcessor);
        }
        return this.convertSendAndReceive(this.getRequiredDefaultDestinationName(), request, targetClass, postProcessor);
    }

    @Override
    public <T> @Nullable T convertSendAndReceive(String destinationName, Object request, Class<T> targetClass, @Nullable MessagePostProcessor requestPostProcessor) throws MessagingException {
        return this.convertSendAndReceive(destinationName, request, null, targetClass, requestPostProcessor);
    }

    @Override
    public <T> @Nullable T convertSendAndReceive(String destinationName, Object request, @Nullable Map<String, Object> headers, Class<T> targetClass, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        org.springframework.messaging.Message requestMessage = this.doConvert(request, headers, postProcessor);
        org.springframework.messaging.Message<?> replyMessage = this.sendAndReceive(destinationName, requestMessage);
        return (T)(replyMessage != null ? this.getMessageConverter().fromMessage(replyMessage, targetClass) : null);
    }

    protected void doSend(Destination destination, org.springframework.messaging.Message<?> message) {
        try {
            this.obtainJmsTemplate().send(destination, (MessageCreator)this.createMessageCreator(message));
        }
        catch (JmsException ex) {
            throw this.convertJmsException(ex);
        }
    }

    protected void doSend(String destinationName, org.springframework.messaging.Message<?> message) {
        try {
            this.obtainJmsTemplate().send(destinationName, (MessageCreator)this.createMessageCreator(message));
        }
        catch (JmsException ex) {
            throw this.convertJmsException(ex);
        }
    }

    protected @Nullable org.springframework.messaging.Message<?> doReceive(Destination destination) {
        try {
            Message jmsMessage = this.obtainJmsTemplate().receive(destination);
            return this.convertJmsMessage(jmsMessage);
        }
        catch (JmsException ex) {
            throw this.convertJmsException(ex);
        }
    }

    protected @Nullable org.springframework.messaging.Message<?> doReceive(String destinationName) {
        try {
            Message jmsMessage = this.obtainJmsTemplate().receive(destinationName);
            return this.convertJmsMessage(jmsMessage);
        }
        catch (JmsException ex) {
            throw this.convertJmsException(ex);
        }
    }

    protected @Nullable org.springframework.messaging.Message<?> doReceiveSelected(Destination destination, @Nullable String messageSelector) {
        try {
            Message jmsMessage = this.obtainJmsTemplate().receiveSelected(destination, messageSelector);
            return this.convertJmsMessage(jmsMessage);
        }
        catch (JmsException ex) {
            throw this.convertJmsException(ex);
        }
    }

    protected @Nullable org.springframework.messaging.Message<?> doReceiveSelected(String destinationName, @Nullable String messageSelector) {
        try {
            Message jmsMessage = this.obtainJmsTemplate().receiveSelected(destinationName, messageSelector);
            return this.convertJmsMessage(jmsMessage);
        }
        catch (JmsException ex) {
            throw this.convertJmsException(ex);
        }
    }

    protected @Nullable org.springframework.messaging.Message<?> doSendAndReceive(Destination destination, org.springframework.messaging.Message<?> requestMessage) {
        try {
            Message jmsMessage = this.obtainJmsTemplate().sendAndReceive(destination, (MessageCreator)this.createMessageCreator(requestMessage));
            return this.convertJmsMessage(jmsMessage);
        }
        catch (JmsException ex) {
            throw this.convertJmsException(ex);
        }
    }

    protected @Nullable org.springframework.messaging.Message<?> doSendAndReceive(String destinationName, org.springframework.messaging.Message<?> requestMessage) {
        try {
            Message jmsMessage = this.obtainJmsTemplate().sendAndReceive(destinationName, (MessageCreator)this.createMessageCreator(requestMessage));
            return this.convertJmsMessage(jmsMessage);
        }
        catch (JmsException ex) {
            throw this.convertJmsException(ex);
        }
    }

    private MessagingMessageCreator createMessageCreator(org.springframework.messaging.Message<?> message) {
        return new MessagingMessageCreator(message, this.getJmsMessageConverter());
    }

    protected String getRequiredDefaultDestinationName() {
        String name = this.getDefaultDestinationName();
        if (name == null) {
            throw new IllegalStateException("No 'defaultDestination' or 'defaultDestinationName' specified. Check configuration of JmsMessagingTemplate.");
        }
        return name;
    }

    protected @Nullable org.springframework.messaging.Message<?> convertJmsMessage(@Nullable Message message) {
        if (message == null) {
            return null;
        }
        try {
            return (org.springframework.messaging.Message)this.getJmsMessageConverter().fromMessage(message);
        }
        catch (Exception ex) {
            throw new MessageConversionException("Could not convert '" + String.valueOf(message) + "'", (Throwable)ex);
        }
    }

    protected MessagingException convertJmsException(JmsException ex) {
        if (ex instanceof org.springframework.jms.support.destination.DestinationResolutionException || ex instanceof InvalidDestinationException) {
            return new DestinationResolutionException(ex.getMessage(), (Throwable)((Object)ex));
        }
        if (ex instanceof org.springframework.jms.support.converter.MessageConversionException) {
            return new MessageConversionException(ex.getMessage(), (Throwable)((Object)ex));
        }
        return new MessagingException(ex.getMessage(), (Throwable)((Object)ex));
    }

    private static class MessagingMessageCreator
    implements MessageCreator {
        private final org.springframework.messaging.Message<?> message;
        private final MessageConverter messageConverter;

        public MessagingMessageCreator(org.springframework.messaging.Message<?> message, MessageConverter messageConverter) {
            this.message = message;
            this.messageConverter = messageConverter;
        }

        @Override
        public Message createMessage(Session session) throws JMSException {
            try {
                return this.messageConverter.toMessage(this.message, session);
            }
            catch (Exception ex) {
                throw new MessageConversionException("Could not convert '" + String.valueOf(this.message) + "': " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

