/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.core;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import java.util.Map;
import java.util.Optional;
import org.springframework.jms.core.DefaultJmsClient;
import org.springframework.jms.core.DefaultJmsClientBuilder;
import org.springframework.jms.core.JmsOperations;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.core.MessagePostProcessor;

public interface JmsClient {
    public OperationSpec destination(Destination var1);

    public OperationSpec destination(String var1);

    public static JmsClient create(ConnectionFactory connectionFactory) {
        return new DefaultJmsClient(connectionFactory);
    }

    public static JmsClient create(JmsOperations jmsTemplate) {
        return new DefaultJmsClient(jmsTemplate);
    }

    public static Builder builder(ConnectionFactory connectionFactory) {
        return new DefaultJmsClientBuilder(connectionFactory);
    }

    public static Builder builder(JmsOperations jmsTemplate) {
        return new DefaultJmsClientBuilder(jmsTemplate);
    }

    public static interface OperationSpec {
        public OperationSpec withReceiveTimeout(long var1);

        public OperationSpec withDeliveryDelay(long var1);

        public OperationSpec withDeliveryPersistent(boolean var1);

        public OperationSpec withPriority(int var1);

        public OperationSpec withTimeToLive(long var1);

        public void send(Message<?> var1) throws MessagingException;

        public void send(Object var1) throws MessagingException;

        public void send(Object var1, Map<String, Object> var2) throws MessagingException;

        public Optional<Message<?>> receive() throws MessagingException;

        public <T> Optional<T> receive(Class<T> var1) throws MessagingException;

        public Optional<Message<?>> receive(String var1) throws MessagingException;

        public <T> Optional<T> receive(String var1, Class<T> var2) throws MessagingException;

        public Optional<Message<?>> sendAndReceive(Message<?> var1) throws MessagingException;

        public <T> Optional<T> sendAndReceive(Object var1, Class<T> var2) throws MessagingException;

        public <T> Optional<T> sendAndReceive(Object var1, Map<String, Object> var2, Class<T> var3) throws MessagingException;
    }

    public static interface Builder {
        public Builder messageConverter(MessageConverter var1);

        public Builder messagePostProcessor(MessagePostProcessor var1);

        public JmsClient build();
    }
}

