/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.core;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.jms.core.JmsClient;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.JmsAccessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.util.Assert;

class DefaultJmsClient
implements JmsClient {
    private final JmsOperations jmsTemplate;
    private @Nullable MessageConverter messageConverter;
    private @Nullable MessagePostProcessor messagePostProcessor;

    public DefaultJmsClient(ConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        this.jmsTemplate = new JmsTemplate(connectionFactory);
    }

    public DefaultJmsClient(JmsOperations jmsTemplate) {
        Assert.notNull((Object)jmsTemplate, (String)"JmsTemplate must not be null");
        this.jmsTemplate = jmsTemplate;
    }

    void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"MessageConverter must not be null");
        this.messageConverter = messageConverter;
    }

    void setMessagePostProcessor(MessagePostProcessor messagePostProcessor) {
        Assert.notNull((Object)messagePostProcessor, (String)"MessagePostProcessor must not be null");
        this.messagePostProcessor = messagePostProcessor;
    }

    @Override
    public JmsClient.OperationSpec destination(Destination destination) {
        return new DefaultOperationSpec(destination);
    }

    @Override
    public JmsClient.OperationSpec destination(String destinationName) {
        return new DefaultOperationSpec(destinationName);
    }

    private JmsMessagingTemplate newDelegate() {
        JmsMessagingTemplate delegate = new JmsMessagingTemplate(this.jmsTemplate);
        MessageConverter converter = this.messageConverter;
        if (converter != null) {
            delegate.setMessageConverter(converter);
        }
        return delegate;
    }

    private class DefaultOperationSpec
    implements JmsClient.OperationSpec {
        private final JmsMessagingTemplate delegate;
        private @Nullable JmsTemplate customTemplate;

        public DefaultOperationSpec(Destination destination) {
            this.delegate = DefaultJmsClient.this.newDelegate();
            this.delegate.setDefaultDestination(destination);
        }

        public DefaultOperationSpec(String destinationName) {
            this.delegate = DefaultJmsClient.this.newDelegate();
            this.delegate.setDefaultDestinationName(destinationName);
        }

        private JmsTemplate enforceCustomTemplate(boolean qos) {
            if (this.customTemplate == null) {
                JmsOperations jmsOperations = DefaultJmsClient.this.jmsTemplate;
                if (!(jmsOperations instanceof JmsAccessor)) {
                    throw new IllegalStateException("Needs to be bound to a JmsAccessor for custom settings support: " + String.valueOf(jmsOperations));
                }
                JmsAccessor original = (JmsAccessor)((Object)jmsOperations);
                this.customTemplate = new JmsTemplate(original);
                this.delegate.setJmsTemplate(this.customTemplate);
            }
            if (qos) {
                this.customTemplate.setExplicitQosEnabled(true);
            }
            return this.customTemplate;
        }

        @Override
        public JmsClient.OperationSpec withReceiveTimeout(long receiveTimeout) {
            this.enforceCustomTemplate(false).setReceiveTimeout(receiveTimeout);
            return this;
        }

        @Override
        public JmsClient.OperationSpec withDeliveryDelay(long deliveryDelay) {
            this.enforceCustomTemplate(false).setDeliveryDelay(deliveryDelay);
            return this;
        }

        @Override
        public JmsClient.OperationSpec withDeliveryPersistent(boolean persistent) {
            this.enforceCustomTemplate(true).setDeliveryPersistent(persistent);
            return this;
        }

        @Override
        public JmsClient.OperationSpec withPriority(int priority) {
            this.enforceCustomTemplate(true).setPriority(priority);
            return this;
        }

        @Override
        public JmsClient.OperationSpec withTimeToLive(long timeToLive) {
            this.enforceCustomTemplate(true).setTimeToLive(timeToLive);
            return this;
        }

        @Override
        public void send(Message<?> message) throws MessagingException {
            message = this.postProcessMessage(message);
            this.delegate.send(message);
        }

        @Override
        public void send(Object payload) throws MessagingException {
            this.delegate.convertAndSend(payload, DefaultJmsClient.this.messagePostProcessor);
        }

        @Override
        public void send(Object payload, Map<String, Object> headers) throws MessagingException {
            this.delegate.convertAndSend(payload, headers, DefaultJmsClient.this.messagePostProcessor);
        }

        @Override
        public Optional<Message<?>> receive() throws MessagingException {
            return Optional.ofNullable(this.delegate.receive());
        }

        @Override
        public <T> Optional<T> receive(Class<T> targetClass) throws MessagingException {
            return Optional.ofNullable(this.delegate.receiveAndConvert(targetClass));
        }

        @Override
        public Optional<Message<?>> receive(String messageSelector) throws MessagingException {
            return Optional.ofNullable(this.delegate.receiveSelected(messageSelector));
        }

        @Override
        public <T> Optional<T> receive(String messageSelector, Class<T> targetClass) throws MessagingException {
            return Optional.ofNullable(this.delegate.receiveSelectedAndConvert(messageSelector, targetClass));
        }

        @Override
        public Optional<Message<?>> sendAndReceive(Message<?> requestMessage) throws MessagingException {
            requestMessage = this.postProcessMessage(requestMessage);
            return Optional.ofNullable(this.delegate.sendAndReceive(requestMessage));
        }

        @Override
        public <T> Optional<T> sendAndReceive(Object request, Class<T> targetClass) throws MessagingException {
            return Optional.ofNullable(this.delegate.convertSendAndReceive(request, targetClass, DefaultJmsClient.this.messagePostProcessor));
        }

        @Override
        public <T> Optional<T> sendAndReceive(Object request, Map<String, Object> headers, Class<T> targetClass) throws MessagingException {
            return Optional.ofNullable(this.delegate.convertSendAndReceive(request, headers, targetClass, DefaultJmsClient.this.messagePostProcessor));
        }

        private Message<?> postProcessMessage(Message<?> message) {
            if (DefaultJmsClient.this.messagePostProcessor != null) {
                return DefaultJmsClient.this.messagePostProcessor.postProcessMessage(message);
            }
            return message;
        }
    }
}

