/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueReceiver;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import org.jspecify.annotations.Nullable;

class CachedMessageConsumer
implements MessageConsumer,
QueueReceiver,
TopicSubscriber {
    protected final MessageConsumer target;

    public CachedMessageConsumer(MessageConsumer target) {
        this.target = target;
    }

    public String getMessageSelector() throws JMSException {
        return this.target.getMessageSelector();
    }

    public @Nullable Queue getQueue() throws JMSException {
        Queue queue;
        MessageConsumer messageConsumer = this.target;
        if (messageConsumer instanceof QueueReceiver) {
            QueueReceiver receiver = (QueueReceiver)messageConsumer;
            queue = receiver.getQueue();
        } else {
            queue = null;
        }
        return queue;
    }

    public @Nullable Topic getTopic() throws JMSException {
        Topic topic;
        MessageConsumer messageConsumer = this.target;
        if (messageConsumer instanceof TopicSubscriber) {
            TopicSubscriber subscriber = (TopicSubscriber)messageConsumer;
            topic = subscriber.getTopic();
        } else {
            topic = null;
        }
        return topic;
    }

    public boolean getNoLocal() throws JMSException {
        TopicSubscriber subscriber;
        MessageConsumer messageConsumer = this.target;
        return messageConsumer instanceof TopicSubscriber && (subscriber = (TopicSubscriber)messageConsumer).getNoLocal();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.target.getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.target.setMessageListener(messageListener);
    }

    public Message receive() throws JMSException {
        return this.target.receive();
    }

    public Message receive(long timeout) throws JMSException {
        return this.target.receive(timeout);
    }

    public Message receiveNoWait() throws JMSException {
        return this.target.receiveNoWait();
    }

    public void close() throws JMSException {
    }

    public String toString() {
        return "Cached JMS MessageConsumer: " + String.valueOf(this.target);
    }
}

