/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.ConnectionBuilder;
import java.sql.SQLException;
import java.sql.ShardingKey;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.jdbc.datasource.ShardingKeyProvider;

public class ShardingKeyDataSourceAdapter
extends DelegatingDataSource {
    private @Nullable ShardingKeyProvider shardingkeyProvider;

    public ShardingKeyDataSourceAdapter(DataSource dataSource) {
        super(dataSource);
    }

    public ShardingKeyDataSourceAdapter(DataSource dataSource, ShardingKeyProvider shardingKeyProvider) {
        super(dataSource);
        this.shardingkeyProvider = shardingKeyProvider;
    }

    public void setShardingKeyProvider(ShardingKeyProvider shardingKeyProvider) {
        this.shardingkeyProvider = shardingKeyProvider;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.createConnectionBuilder().build();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.createConnectionBuilder().user(username).password(password).build();
    }

    @Override
    public ConnectionBuilder createConnectionBuilder() throws SQLException {
        ConnectionBuilder connectionBuilder = super.createConnectionBuilder();
        if (this.shardingkeyProvider == null) {
            return connectionBuilder;
        }
        ShardingKey shardingKey = this.shardingkeyProvider.getShardingKey();
        ShardingKey superShardingKey = this.shardingkeyProvider.getSuperShardingKey();
        return connectionBuilder.shardingKey(shardingKey).superShardingKey(superShardingKey);
    }
}

