/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.IsolationLevelDataSourceAdapter;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class WebSphereDataSourceAdapter
extends IsolationLevelDataSourceAdapter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class<?> wsDataSourceClass;
    private Method newJdbcConnSpecMethod;
    private Method wsDataSourceGetConnectionMethod;
    private Method setTransactionIsolationMethod;
    private Method setReadOnlyMethod;
    private Method setUserNameMethod;
    private Method setPasswordMethod;

    public WebSphereDataSourceAdapter() {
        try {
            this.wsDataSourceClass = this.getClass().getClassLoader().loadClass("com.ibm.websphere.rsadapter.WSDataSource");
            Class<?> jdbcConnSpecClass = this.getClass().getClassLoader().loadClass("com.ibm.websphere.rsadapter.JDBCConnectionSpec");
            Class<?> wsrraFactoryClass = this.getClass().getClassLoader().loadClass("com.ibm.websphere.rsadapter.WSRRAFactory");
            this.newJdbcConnSpecMethod = wsrraFactoryClass.getMethod("createJDBCConnectionSpec", new Class[0]);
            this.wsDataSourceGetConnectionMethod = this.wsDataSourceClass.getMethod("getConnection", jdbcConnSpecClass);
            this.setTransactionIsolationMethod = jdbcConnSpecClass.getMethod("setTransactionIsolation", Integer.TYPE);
            this.setReadOnlyMethod = jdbcConnSpecClass.getMethod("setReadOnly", Boolean.class);
            this.setUserNameMethod = jdbcConnSpecClass.getMethod("setUserName", String.class);
            this.setPasswordMethod = jdbcConnSpecClass.getMethod("setPassword", String.class);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize WebSphereDataSourceAdapter because WebSphere API classes are not available: " + ex);
        }
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (!this.wsDataSourceClass.isInstance(this.getTargetDataSource())) {
            throw new IllegalStateException("Specified 'targetDataSource' is not a WebSphere WSDataSource: " + this.getTargetDataSource());
        }
    }

    @Override
    protected Connection doGetConnection(String username, String password) throws SQLException {
        Object connSpec = this.createConnectionSpec(this.getCurrentIsolationLevel(), this.getCurrentReadOnlyFlag(), username, password);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Obtaining JDBC Connection from WebSphere DataSource [" + this.getTargetDataSource() + "], using ConnectionSpec [" + connSpec + "]"));
        }
        return (Connection)ReflectionUtils.invokeJdbcMethod((Method)this.wsDataSourceGetConnectionMethod, (Object)this.getTargetDataSource(), (Object[])new Object[]{connSpec});
    }

    protected Object createConnectionSpec(Integer isolationLevel, Boolean readOnlyFlag, String username, String password) throws SQLException {
        Object connSpec = ReflectionUtils.invokeJdbcMethod((Method)this.newJdbcConnSpecMethod, null);
        if (isolationLevel != null) {
            ReflectionUtils.invokeJdbcMethod((Method)this.setTransactionIsolationMethod, (Object)connSpec, (Object[])new Object[]{isolationLevel});
        }
        if (readOnlyFlag != null) {
            ReflectionUtils.invokeJdbcMethod((Method)this.setReadOnlyMethod, (Object)connSpec, (Object[])new Object[]{readOnlyFlag});
        }
        if (StringUtils.hasLength((String)username)) {
            ReflectionUtils.invokeJdbcMethod((Method)this.setUserNameMethod, (Object)connSpec, (Object[])new Object[]{username});
            ReflectionUtils.invokeJdbcMethod((Method)this.setPasswordMethod, (Object)connSpec, (Object[])new Object[]{password});
        }
        return connSpec;
    }
}

