/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import java.sql.Driver;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.jdbc.datasource.embedded.ConnectionProperties;
import org.springframework.jdbc.datasource.embedded.DataSourceFactory;
import org.springframework.util.Assert;

final class SimpleDriverDataSourceFactory
implements DataSourceFactory {
    private final SimpleDriverDataSource dataSource = new SimpleDriverDataSource();

    SimpleDriverDataSourceFactory() {
    }

    public ConnectionProperties getConnectionProperties() {
        return new ConnectionProperties(){

            public void setDriverClass(Class driverClass) {
                Assert.isAssignable(Driver.class, (Class)driverClass);
                SimpleDriverDataSourceFactory.this.dataSource.setDriverClass(driverClass);
            }

            public void setUrl(String url) {
                SimpleDriverDataSourceFactory.this.dataSource.setUrl(url);
            }

            public void setUsername(String username) {
                SimpleDriverDataSourceFactory.this.dataSource.setUsername(username);
            }

            public void setPassword(String password) {
                SimpleDriverDataSourceFactory.this.dataSource.setPassword(password);
            }
        };
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

