/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import org.springframework.jdbc.datasource.embedded.AbstractEmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.ConnectionProperties;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HsqlEmbeddedDatabaseConfigurer
extends AbstractEmbeddedDatabaseConfigurer {
    private static HsqlEmbeddedDatabaseConfigurer INSTANCE;
    private final Class<?> driverClass;

    public static synchronized HsqlEmbeddedDatabaseConfigurer getInstance() throws ClassNotFoundException {
        if (INSTANCE == null) {
            INSTANCE = new HsqlEmbeddedDatabaseConfigurer(ClassUtils.forName((String)"org.hsqldb.jdbcDriver", (ClassLoader)HsqlEmbeddedDatabaseConfigurer.class.getClassLoader()));
        }
        return INSTANCE;
    }

    private HsqlEmbeddedDatabaseConfigurer(Class<?> driverClass) {
        this.driverClass = driverClass;
    }

    @Override
    public void configureConnectionProperties(ConnectionProperties properties, String databaseName) {
        properties.setDriverClass(this.driverClass);
        properties.setUrl("jdbc:hsqldb:mem:" + databaseName);
        properties.setUsername("sa");
        properties.setPassword("");
    }
}

